/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.compress;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.StreamingMetrics;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.FileStreamTask;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedFileStreamTask
extends FileStreamTask {
    private static final Logger logger = LoggerFactory.getLogger(CompressedFileStreamTask.class);
    public static final int CHUNK_SIZE = 0xA00000;

    public CompressedFileStreamTask(StreamHeader header, InetAddress to) {
        super(header, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stream() throws IOException {
        assert (this.header.file.compressionInfo != null);
        SocketChannel sc = this.socket.getChannel();
        byte[] transferBuffer = null;
        ByteBuffer headerBuffer = MessagingService.instance().constructStreamHeader(this.header, false, MessagingService.instance().getVersion(this.to));
        this.socket.getOutputStream().write(ByteBufferUtil.getArray(headerBuffer));
        RandomAccessReader file = RandomAccessReader.open(new File(this.header.file.getFilename()), true);
        FileChannel fc = file.getChannel();
        StreamingMetrics.activeStreamsOutbound.inc();
        List<Pair<Long, Long>> sections = this.getTransferSections(this.header.file.compressionInfo.chunks);
        try {
            long totalBytesTransferred = 0L;
            for (Pair<Long, Long> section : sections) {
                if (sc == null) {
                    file.seek((Long)section.left);
                }
                long length = (Long)section.right - (Long)section.left;
                long bytesTransferred = 0L;
                while (bytesTransferred < length) {
                    long lastWrite;
                    int toTransfer = (int)Math.min(0xA00000L, length - bytesTransferred);
                    if (sc != null) {
                        lastWrite = fc.transferTo((Long)section.left + bytesTransferred, toTransfer, sc);
                        this.throttle.throttleDelta(lastWrite);
                    } else {
                        if (transferBuffer == null) {
                            transferBuffer = new byte[0xA00000];
                        }
                        file.readFully(transferBuffer, 0, toTransfer);
                        this.socket.getOutputStream().write(transferBuffer, 0, toTransfer);
                        this.throttle.throttleDelta(toTransfer);
                        lastWrite = toTransfer;
                    }
                    totalBytesTransferred += lastWrite;
                    bytesTransferred += lastWrite;
                    this.header.file.progress += lastWrite;
                }
                if (sc == null) {
                    this.socket.getOutputStream().flush();
                }
                logger.debug("Bytes transferred " + bytesTransferred + "/" + this.header.file.size);
            }
            StreamingMetrics.totalOutgoingBytes.inc(totalBytesTransferred);
            this.metrics.outgoingBytes.inc(totalBytesTransferred);
            this.receiveReply();
        }
        finally {
            StreamingMetrics.activeStreamsOutbound.dec();
            FileUtils.closeQuietly(file);
        }
    }

    private List<Pair<Long, Long>> getTransferSections(CompressionMetadata.Chunk[] chunks) {
        ArrayList<Pair<Long, Long>> transferSections = new ArrayList<Pair<Long, Long>>();
        Pair<Long, Long> lastSection = null;
        for (CompressionMetadata.Chunk chunk : chunks) {
            if (lastSection != null) {
                if (chunk.offset == (Long)lastSection.right) {
                    lastSection = Pair.create(lastSection.left, chunk.offset + (long)chunk.length + 4L);
                    continue;
                }
                transferSections.add(lastSection);
                lastSection = Pair.create(chunk.offset, chunk.offset + (long)chunk.length + 4L);
                continue;
            }
            lastSection = Pair.create(chunk.offset, chunk.offset + (long)chunk.length + 4L);
        }
        if (lastSection != null) {
            transferSections.add(lastSection);
        }
        return transferSections;
    }
}

