/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.locator.ReconnectableSnitchHelper;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipingPropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(GossipingPropertyFileSnitch.class);
    private PropertyFileSnitch psnitch;
    private String myDC = SnitchProperties.get("dc", null);
    private String myRack = SnitchProperties.get("rack", null);
    private Map<InetAddress, Map<String, String>> savedEndpoints;
    private String DEFAULT_DC = "UNKNOWN_DC";
    private String DEFAULT_RACK = "UNKNOWN_RACK";
    private final boolean preferLocal;

    public GossipingPropertyFileSnitch() throws ConfigurationException {
        if (this.myDC == null || this.myRack == null) {
            throw new ConfigurationException("DC or rack not found in snitch properties, check your configuration in: cassandra-rackdc.properties");
        }
        this.myDC = this.myDC.trim();
        this.myRack = this.myRack.trim();
        this.preferLocal = Boolean.parseBoolean(SnitchProperties.get("prefer_local", "false"));
        try {
            this.psnitch = new PropertyFileSnitch();
            logger.info("Loaded cassandra-topology.properties for compatibility");
        }
        catch (ConfigurationException e) {
            logger.info("Unable to load cassandra-topology.properties; compatibility mode disabled");
        }
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.myDC;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.DC) == null) {
            if (this.psnitch == null) {
                if (this.savedEndpoints == null) {
                    this.savedEndpoints = SystemTable.loadDcRackInfo();
                }
                if (this.savedEndpoints.containsKey(endpoint)) {
                    return this.savedEndpoints.get(endpoint).get("data_center");
                }
                return this.DEFAULT_DC;
            }
            return this.psnitch.getDatacenter(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public String getRack(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.myRack;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.RACK) == null) {
            if (this.psnitch == null) {
                if (this.savedEndpoints == null) {
                    this.savedEndpoints = SystemTable.loadDcRackInfo();
                }
                if (this.savedEndpoints.containsKey(endpoint)) {
                    return this.savedEndpoints.get(endpoint).get("rack");
                }
                return this.DEFAULT_RACK;
            }
            return this.psnitch.getRack(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public void gossiperStarting() {
        super.gossiperStarting();
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(FBUtilities.getLocalAddress().getHostAddress()));
        Gossiper.instance.register(new ReconnectableSnitchHelper(this, this.myDC, this.preferLocal));
    }
}

