/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Charsets;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ec2Snitch
extends AbstractNetworkTopologySnitch {
    protected static final Logger logger = LoggerFactory.getLogger(Ec2Snitch.class);
    protected static final String ZONE_NAME_QUERY_URL = "http://169.254.169.254/latest/meta-data/placement/availability-zone";
    private static final String DEFAULT_DC = "UNKNOWN-DC";
    private static final String DEFAULT_RACK = "UNKNOWN-RACK";
    protected String ec2zone;
    protected String ec2region;

    public Ec2Snitch() throws IOException, ConfigurationException {
        String az = this.awsApiCall(ZONE_NAME_QUERY_URL);
        String[] splits = az.split("-");
        this.ec2zone = splits[splits.length - 1];
        this.ec2region = az.substring(0, az.length() - 1);
        if (this.ec2region.endsWith("1")) {
            this.ec2region = az.substring(0, az.length() - 3);
        }
        String datacenterSuffix = SnitchProperties.get("dc_suffix", "");
        this.ec2region = this.ec2region.concat(datacenterSuffix);
        logger.info("EC2Snitch using region: " + this.ec2region + ", zone: " + this.ec2zone + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String awsApiCall(String url) throws IOException, ConfigurationException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new ConfigurationException("Ec2Snitch was unable to execute the API call. Not an ec2 node?");
            }
            int cl = conn.getContentLength();
            byte[] b = new byte[cl];
            DataInputStream d = new DataInputStream((FilterInputStream)conn.getContent());
            d.readFully(b);
            String string = new String(b, Charsets.UTF_8);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    @Override
    public String getRack(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.ec2zone;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.ec2region;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }
}

