/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCompactionStrategy.class);
    protected static final float DEFAULT_TOMBSTONE_THRESHOLD = 0.2f;
    protected static final long DEFAULT_TOMBSTONE_COMPACTION_INTERVAL = 86400L;
    protected static final String TOMBSTONE_THRESHOLD_OPTION = "tombstone_threshold";
    protected static final String TOMBSTONE_COMPACTION_INTERVAL_OPTION = "tombstone_compaction_interval";
    public final Map<String, String> options;
    protected final ColumnFamilyStore cfs;
    protected float tombstoneThreshold;
    protected long tombstoneCompactionInterval;

    protected AbstractCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        assert (cfs != null);
        this.cfs = cfs;
        this.options = options;
        try {
            AbstractCompactionStrategy.validateOptions(options);
            String optionValue = options.get(TOMBSTONE_THRESHOLD_OPTION);
            this.tombstoneThreshold = optionValue == null ? 0.2f : Float.parseFloat(optionValue);
            optionValue = options.get(TOMBSTONE_COMPACTION_INTERVAL_OPTION);
            this.tombstoneCompactionInterval = optionValue == null ? 86400L : Long.parseLong(optionValue);
        }
        catch (ConfigurationException e) {
            logger.warn("Error setting compaction strategy options ({}), defaults will be used", (Object)e.getMessage());
            this.tombstoneThreshold = 0.2f;
            this.tombstoneCompactionInterval = 86400L;
        }
    }

    public void shutdown() {
    }

    public abstract AbstractCompactionTask getNextBackgroundTask(int var1);

    public abstract AbstractCompactionTask getMaximalTask(int var1);

    public abstract AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> var1, int var2);

    public abstract int getEstimatedRemainingTasks();

    public abstract long getMaxSSTableSize();

    public static List<SSTableReader> filterSuspectSSTables(Collection<SSTableReader> originalCandidates) {
        ArrayList<SSTableReader> filteredCandidates = new ArrayList<SSTableReader>();
        for (SSTableReader candidate : originalCandidates) {
            if (candidate.isMarkedSuspect()) continue;
            filteredCandidates.add(candidate);
        }
        return filteredCandidates;
    }

    public List<ICompactionScanner> getScanners(Collection<SSTableReader> sstables, Range<Token> range) {
        RateLimiter limiter = CompactionManager.instance.getRateLimiter();
        ArrayList<ICompactionScanner> scanners = new ArrayList<ICompactionScanner>();
        for (SSTableReader sstable : sstables) {
            scanners.add(sstable.getDirectScanner(range, limiter));
        }
        return scanners;
    }

    public List<ICompactionScanner> getScanners(Collection<SSTableReader> toCompact) {
        return this.getScanners(toCompact, null);
    }

    protected boolean worthDroppingTombstones(SSTableReader sstable, int gcBefore) {
        if (System.currentTimeMillis() < sstable.getCreationTimeFor(Component.DATA) + this.tombstoneCompactionInterval * 1000L) {
            return false;
        }
        double droppableRatio = sstable.getEstimatedDroppableTombstoneRatio(gcBefore);
        if (droppableRatio <= (double)this.tombstoneThreshold) {
            return false;
        }
        Set<SSTableReader> overlaps = this.cfs.getOverlappingSSTables(Collections.singleton(sstable));
        if (overlaps.isEmpty()) {
            return true;
        }
        if (sstable.getKeySamples().length < 2) {
            return false;
        }
        long keys = sstable.estimatedKeys();
        HashSet<Range<Token>> ranges = new HashSet<Range<Token>>();
        for (SSTableReader overlap : overlaps) {
            ranges.add(new Range<Token>(overlap.first.token, overlap.last.token, overlap.partitioner));
        }
        long remainingKeys = keys - sstable.estimatedKeysForRanges(ranges);
        long columns = sstable.getEstimatedColumnCount().mean() * remainingKeys;
        double remainingColumnsRatio = (double)columns / (double)(sstable.getEstimatedColumnCount().count() * sstable.getEstimatedColumnCount().mean());
        return remainingColumnsRatio * droppableRatio > (double)this.tombstoneThreshold;
    }

    public static Map<String, String> validateOptions(Map<String, String> options) throws ConfigurationException {
        String interval;
        String threshold = options.get(TOMBSTONE_THRESHOLD_OPTION);
        if (threshold != null) {
            try {
                float thresholdValue = Float.parseFloat(threshold);
                if (thresholdValue < 0.0f) {
                    throw new ConfigurationException(String.format("%s must be greater than 0, but was %f", TOMBSTONE_THRESHOLD_OPTION, Float.valueOf(thresholdValue)));
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", threshold, TOMBSTONE_THRESHOLD_OPTION), e);
            }
        }
        if ((interval = options.get(TOMBSTONE_COMPACTION_INTERVAL_OPTION)) != null) {
            try {
                long tombstoneCompactionInterval = Long.parseLong(interval);
                if (tombstoneCompactionInterval < 0L) {
                    throw new ConfigurationException(String.format("%s must be greater than 0, but was %d", TOMBSTONE_COMPACTION_INTERVAL_OPTION, tombstoneCompactionInterval));
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", interval, TOMBSTONE_COMPACTION_INTERVAL_OPTION), e);
            }
        }
        HashMap<String, String> uncheckedOptions = new HashMap<String, String>(options);
        uncheckedOptions.remove(TOMBSTONE_THRESHOLD_OPTION);
        uncheckedOptions.remove(TOMBSTONE_COMPACTION_INTERVAL_OPTION);
        return uncheckedOptions;
    }
}

