/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexScanCommand;
import org.apache.cassandra.db.RangeSliceCommandSerializer;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.ByteBufferUtil;

public class RangeSliceCommand
implements IReadCommand {
    public static final RangeSliceCommandSerializer serializer = new RangeSliceCommandSerializer();
    public final String keyspace;
    public final String column_family;
    public final ByteBuffer super_column;
    public final IDiskAtomFilter predicate;
    public final List<IndexExpression> row_filter;
    public final AbstractBounds<RowPosition> range;
    public final int maxResults;
    public final boolean countCQL3Rows;
    public final boolean isPaging;

    public RangeSliceCommand(String keyspace, String column_family, ByteBuffer super_column, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, int maxResults) {
        this(keyspace, column_family, super_column, predicate, range, null, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, ColumnParent column_parent, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> row_filter, int maxResults) {
        this(keyspace, column_parent.getColumn_family(), column_parent.super_column, predicate, range, row_filter, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, String column_family, ByteBuffer super_column, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> row_filter, int maxResults) {
        this(keyspace, column_family, super_column, predicate, range, row_filter, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, String column_family, ByteBuffer super_column, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> row_filter, int maxResults, boolean countCQL3Rows, boolean isPaging) {
        this.keyspace = keyspace;
        this.column_family = column_family;
        this.super_column = super_column;
        this.predicate = predicate;
        this.range = range;
        this.row_filter = row_filter;
        this.maxResults = maxResults;
        this.countCQL3Rows = countCQL3Rows;
        this.isPaging = isPaging;
    }

    public MessageOut<RangeSliceCommand> createMessage() {
        return new MessageOut<RangeSliceCommand>(MessagingService.Verb.RANGE_SLICE, this, serializer);
    }

    public String toString() {
        return "RangeSliceCommand{keyspace='" + this.keyspace + '\'' + ", column_family='" + this.column_family + '\'' + ", super_column=" + this.super_column + ", predicate=" + this.predicate + ", range=" + this.range + ", row_filter =" + this.row_filter + ", maxResults=" + this.maxResults + ", countCQL3Rows=" + this.countCQL3Rows + '}';
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public IndexScanCommand toIndexScanCommand() {
        assert (this.row_filter != null && !this.row_filter.isEmpty());
        if (this.countCQL3Rows || this.isPaging) {
            throw new IllegalStateException("Cannot proceed with range query as the remote end has a version < 1.1. Please update the full cluster first.");
        }
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace, this.column_family);
        try {
            if (!ThriftValidation.validateFilterClauses(cfm, this.row_filter)) {
                throw new IllegalStateException("Cannot proceed with non-indexed query as the remote end has a version < 1.1. Please update the full cluster first.");
            }
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        RowPosition start = (RowPosition)this.range.left;
        ByteBuffer startKey = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        if (start instanceof DecoratedKey) {
            startKey = ((DecoratedKey)start).key;
        }
        IndexClause clause = new IndexClause(this.row_filter, startKey, this.maxResults);
        SlicePredicate pred = RangeSliceCommandSerializer.asSlicePredicate(this.predicate);
        return new IndexScanCommand(this.keyspace, this.column_family, clause, pred, this.range);
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }
}

