/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Iterator;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;

public abstract class AbstractThreadUnsafeSortedColumns
implements ISortedColumns {
    private DeletionInfo deletionInfo = DeletionInfo.live();

    @Override
    public DeletionInfo getDeletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public void delete(DeletionInfo newInfo) {
        this.deletionInfo.add(newInfo);
    }

    @Override
    public void delete(RangeTombstone tombstone) {
        this.deletionInfo.add(tombstone, this.getComparator());
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.deletionInfo = newInfo;
    }

    @Override
    public void maybeResetDeletionTimes(int gcBefore) {
        this.deletionInfo.purge(gcBefore);
    }

    @Override
    public void retainAll(ISortedColumns columns) {
        Iterator iter = this.iterator();
        Iterator toRetain = columns.iterator();
        IColumn current = iter.hasNext() ? (IColumn)iter.next() : null;
        IColumn retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
        AbstractType<?> comparator = this.getComparator();
        while (current != null && retain != null) {
            int c = comparator.compare(current.name(), retain.name());
            if (c == 0) {
                if (current instanceof SuperColumn) {
                    assert (retain instanceof SuperColumn);
                    ((SuperColumn)current).retainAll((SuperColumn)retain);
                }
                current = iter.hasNext() ? (IColumn)iter.next() : null;
                retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
                continue;
            }
            if (c < 0) {
                iter.remove();
                current = iter.hasNext() ? (IColumn)iter.next() : null;
                continue;
            }
            retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
        }
        while (current != null) {
            iter.remove();
            current = iter.hasNext() ? (IColumn)iter.next() : null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.size();
    }
}

