/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.UserOptions;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class AlterUserStatement
extends AuthenticationStatement {
    private final String username;
    private final UserOptions opts;
    private final Boolean superuser;

    public AlterUserStatement(String username, UserOptions opts, Boolean superuser) {
        this.username = username;
        this.opts = opts;
        this.superuser = superuser;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        this.opts.validate();
        if (this.superuser == null && this.opts.isEmpty()) {
            throw new InvalidRequestException("ALTER USER can't be empty");
        }
        state.ensureNotAnonymous();
        if (!Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s doesn't exist", this.username));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        AuthenticatedUser user = state.getUser();
        boolean isSuper = user.isSuper();
        if (this.superuser != null && user.getName().equals(this.username)) {
            throw new UnauthorizedException("You aren't allowed to alter your own superuser status");
        }
        if (this.superuser != null && !isSuper) {
            throw new UnauthorizedException("Only superusers are allowed to alter superuser status");
        }
        if (!user.isSuper() && !user.getName().equals(this.username)) {
            throw new UnauthorizedException("You aren't allowed to alter this user");
        }
        if (!isSuper) {
            for (IAuthenticator.Option option : this.opts.getOptions().keySet()) {
                if (DatabaseDescriptor.getAuthenticator().alterableOptions().contains((Object)option)) continue;
                throw new UnauthorizedException(String.format("You aren't allowed to alter %s option", new Object[]{option}));
            }
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        if (!this.opts.isEmpty()) {
            DatabaseDescriptor.getAuthenticator().alter(this.username, this.opts.getOptions());
        }
        if (this.superuser != null) {
            Auth.insertUser(this.username, this.superuser);
        }
        return null;
    }
}

