/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.io.util.Memory;

public class RefCountedMemory
extends Memory {
    private final AtomicInteger references = new AtomicInteger(1);

    public RefCountedMemory(long size) {
        super(size);
    }

    public boolean reference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public void unreference() {
        if (this.references.decrementAndGet() == 0) {
            this.free();
        }
    }
}

