/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnFamilyInputFormat<K, Y>
extends InputFormat<K, Y>
implements org.apache.hadoop.mapred.InputFormat<K, Y> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractColumnFamilyInputFormat.class);
    public static final String MAPRED_TASK_ID = "mapred.task.id";
    public static final String CASSANDRA_HADOOP_MAX_KEY_SIZE = "cassandra.hadoop.max_key_size";
    public static final int CASSANDRA_HADOOP_MAX_KEY_SIZE_DEFAULT = 8192;
    private String keyspace;
    private String cfName;
    private IPartitioner partitioner;

    protected void validateConfiguration(Configuration conf) {
        if (ConfigHelper.getInputKeyspace(conf) == null || ConfigHelper.getInputColumnFamily(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace and columnfamily with setInputColumnFamily()");
        }
        if (ConfigHelper.getInputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node with setInputInitialAddress");
        }
        if (ConfigHelper.getInputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the Cassandra partitioner class with setInputPartitioner");
        }
    }

    public static Cassandra.Client createAuthenticatedClient(String location, int port, Configuration conf) throws Exception {
        logger.debug("Creating authenticated client for CF input format");
        TTransport transport = ConfigHelper.getClientTransportFactory(conf).openTransport(location, port, conf);
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport, true, true);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        client.set_keyspace(ConfigHelper.getInputKeyspace(conf));
        if (ConfigHelper.getInputKeyspaceUserName(conf) != null) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("username", ConfigHelper.getInputKeyspaceUserName(conf));
            creds.put("password", ConfigHelper.getInputKeyspacePassword(conf));
            AuthenticationRequest authRequest = new AuthenticationRequest(creds);
            client.login(authRequest);
        }
        logger.debug("Authenticated client for CF input format created successfully");
        return client;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        return null;
    }

    /*
     * Exception decompiling
     */
    public List<InputSplit> getSplits(Configuration conf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<CfSplit> getSubSplits(String keyspace, String cfName, TokenRange range, Configuration conf) throws IOException {
        int splitsize = ConfigHelper.getInputSplitSize(conf);
        for (int i = 0; i < range.rpc_endpoints.size(); ++i) {
            String host = (String)range.rpc_endpoints.get(i);
            if (host == null || host.equals("0.0.0.0")) {
                host = (String)range.endpoints.get(i);
            }
            try {
                Cassandra.Client client = ConfigHelper.createConnection(conf, host, ConfigHelper.getInputRpcPort(conf));
                client.set_keyspace(keyspace);
                try {
                    return client.describe_splits_ex(cfName, range.start_token, range.end_token, splitsize);
                }
                catch (TApplicationException e) {
                    if (e.getType() == 1) {
                        List splitPoints = client.describe_splits(cfName, range.start_token, range.end_token, splitsize);
                        return this.tokenListToSplits(splitPoints, splitsize);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                logger.debug("failed connect to endpoint " + host, (Throwable)e);
                continue;
            }
            catch (InvalidRequestException e) {
                throw new RuntimeException(e);
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IOException("failed connecting to all endpoints " + StringUtils.join((Collection)range.endpoints, (String)","));
    }

    private List<CfSplit> tokenListToSplits(List<String> splitTokens, int splitsize) {
        ArrayList splits = Lists.newArrayListWithExpectedSize((int)(splitTokens.size() - 1));
        for (int j = 0; j < splitTokens.size() - 1; ++j) {
            splits.add(new CfSplit(splitTokens.get(j), splitTokens.get(j + 1), (long)splitsize));
        }
        return splits;
    }

    private List<TokenRange> getRangeMap(Configuration conf) throws IOException {
        List map;
        Cassandra.Client client = ConfigHelper.getClientFromInputAddressList(conf);
        try {
            map = client.describe_ring(ConfigHelper.getInputKeyspace(conf));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        List<InputSplit> newInputSplits = this.getSplits((Configuration)jobConf);
        org.apache.hadoop.mapred.InputSplit[] oldInputSplits = new org.apache.hadoop.mapred.InputSplit[newInputSplits.size()];
        for (int i = 0; i < newInputSplits.size(); ++i) {
            oldInputSplits[i] = (ColumnFamilySplit)newInputSplits.get(i);
        }
        return oldInputSplits;
    }

    class SplitCallable
    implements Callable<List<InputSplit>> {
        private final TokenRange range;
        private final Configuration conf;

        public SplitCallable(TokenRange tr, Configuration conf) {
            this.range = tr;
            this.conf = conf;
        }

        @Override
        public List<InputSplit> call() throws Exception {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            List subSplits = AbstractColumnFamilyInputFormat.this.getSubSplits(AbstractColumnFamilyInputFormat.this.keyspace, AbstractColumnFamilyInputFormat.this.cfName, this.range, this.conf);
            assert (this.range.rpc_endpoints.size() == this.range.endpoints.size()) : "rpc_endpoints size must match endpoints size";
            String[] endpoints = this.range.endpoints.toArray(new String[this.range.endpoints.size()]);
            int endpointIndex = 0;
            for (String endpoint : this.range.rpc_endpoints) {
                String endpoint_address = endpoint;
                if (endpoint_address == null || endpoint_address.equals("0.0.0.0")) {
                    endpoint_address = (String)this.range.endpoints.get(endpointIndex);
                }
                endpoints[endpointIndex++] = InetAddress.getByName(endpoint_address).getHostName();
            }
            Token.TokenFactory factory = AbstractColumnFamilyInputFormat.this.partitioner.getTokenFactory();
            for (CfSplit subSplit : subSplits) {
                Token right;
                Token left = factory.fromString(subSplit.getStart_token());
                Range range = new Range(left, right = factory.fromString(subSplit.getEnd_token()), AbstractColumnFamilyInputFormat.this.partitioner);
                ImmutableList ranges = range.isWrapAround() ? range.unwrap() : ImmutableList.of(range);
                for (Range subrange : ranges) {
                    ColumnFamilySplit split = new ColumnFamilySplit(factory.toString((Token)subrange.left), factory.toString((Token)subrange.right), subSplit.getRow_count(), endpoints);
                    logger.debug("adding " + (Object)((Object)split));
                    splits.add(split);
                }
            }
            return splits;
        }
    }
}

