/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;

public class SynsetTypeConverter {
    public static final char NOUN_CODE = 'n';
    public static final char VERB_CODE = 'v';
    public static final char ADJECTIVE_CODE = 'a';
    public static final char ADVERB_CODE = 'r';
    public static final char ADJECTIVE_SATELLITE_CODE = 's';

    public static SynsetType getType(int n) {
        SynsetType synsetType = null;
        SynsetType[] synsetTypeArray = SynsetType.ALL_TYPES;
        for (int i = 0; i < synsetTypeArray.length; ++i) {
            if (n != synsetTypeArray[i].getCode()) continue;
            synsetType = synsetTypeArray[i];
        }
        return synsetType;
    }

    public static SynsetType getType(char c) {
        SynsetType synsetType = null;
        switch (c) {
            case 'n': {
                synsetType = SynsetType.NOUN;
                break;
            }
            case 'v': {
                synsetType = SynsetType.VERB;
                break;
            }
            case 'a': {
                synsetType = SynsetType.ADJECTIVE;
                break;
            }
            case 'r': {
                synsetType = SynsetType.ADVERB;
                break;
            }
            case 's': {
                synsetType = SynsetType.ADJECTIVE_SATELLITE;
                break;
            }
            default: {
                throw new IllegalArgumentException("'" + c + "' is an invalid code.");
            }
        }
        return synsetType;
    }
}

