/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;

public class SenseKey
implements Comparable {
    public static final String LEMMA_TERMINATOR = "%";
    public static final String FIELD_DELIMITER = ":";
    private String lemma;
    private SynsetType type;
    private int lexicalFileNumber;
    private int lexicalID;
    private SenseKey headWord;

    public SenseKey(String string, SynsetType synsetType, int n, int n2, SenseKey senseKey) {
        this.lemma = string;
        this.type = synsetType;
        this.lexicalFileNumber = n;
        this.lexicalID = n2;
        this.headWord = senseKey;
    }

    public SenseKey(String string, SynsetType synsetType, int n, int n2) {
        this(string, synsetType, n, n2, null);
    }

    public String getLemma() {
        return this.lemma;
    }

    public SynsetType getType() {
        return this.type;
    }

    public int getLexicalFileNumber() {
        return this.lexicalFileNumber;
    }

    public int getLexicalID() {
        return this.lexicalID;
    }

    public SenseKey getHeadWord() {
        return this.headWord;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object != null) {
            SenseKey senseKey = (SenseKey)object;
            n = this.getType().compareTo(senseKey.getType());
            if (n == 0 && (n = this.getLemma().compareTo(senseKey.getLemma())) == 0 && (n = this.getLexicalID() - senseKey.getLexicalID()) == 0) {
                n = this.getLexicalFileNumber() - senseKey.getLexicalFileNumber();
            }
        }
        return n;
    }

    public int hashCode() {
        return this.lemma.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof SenseKey) {
            SenseKey senseKey = (SenseKey)object;
            bl = this.getType().equals(senseKey.getType()) && this.getLemma().equals(senseKey.getLemma()) && this.getLexicalFileNumber() == senseKey.getLexicalFileNumber() && this.getLexicalID() == senseKey.getLexicalID();
        }
        return bl;
    }

    public String toString() {
        return this.getFullSenseKeyText();
    }

    public String getPartialSenseKeyText() {
        String string = this.getFullSenseKeyText();
        int n = string.lastIndexOf(FIELD_DELIMITER);
        n = string.lastIndexOf(FIELD_DELIMITER, n - 1);
        return string.substring(0, n + 1);
    }

    public String getFullSenseKeyText() {
        return TextTranslator.translateToDatabaseFormat(this.getLemma()) + LEMMA_TERMINATOR + this.getLexicalSense();
    }

    private String getLexicalSense() {
        return this.type.getCode() + FIELD_DELIMITER + this.pad(this.getLexicalFileNumber(), 2) + FIELD_DELIMITER + this.pad(this.getLexicalID(), 2) + FIELD_DELIMITER + (this.headWord != null ? this.headWord.getLemma() : "") + FIELD_DELIMITER + (this.headWord != null ? this.pad(this.headWord.getLexicalID(), 2) : "");
    }

    private String pad(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }
}

