/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.impl.MultipleLineLocator;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexParser;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SenseIndexReader
extends MultipleLineLocator {
    private static final String SENSE_INDEX_FILE = "index.sense";
    private static final String LEMMA_TERMINATOR = "%";
    private static WeakReference reference;
    private SenseIndexParser parser = new SenseIndexParser();

    public static synchronized SenseIndexReader getInstance() throws RetrievalException {
        SenseIndexReader senseIndexReader = null;
        if (reference != null) {
            senseIndexReader = (SenseIndexReader)reference.get();
        }
        if (senseIndexReader == null) {
            try {
                senseIndexReader = new SenseIndexReader();
                reference = new WeakReference<SenseIndexReader>(senseIndexReader);
            }
            catch (IOException iOException) {
                throw new RetrievalException("Error opening index file: " + iOException.getMessage(), iOException);
            }
        }
        return senseIndexReader;
    }

    private SenseIndexReader() throws IOException {
        super(System.getProperty("wordnet.database.dir", "."), SENSE_INDEX_FILE);
    }

    public SenseIndexEntry getEntry(String string) throws RetrievalException {
        SenseIndexEntry[] senseIndexEntryArray = this.getAllEntries(string);
        if (senseIndexEntryArray.length != 1) {
            throw new RetrievalException("Expected to find exactly one line that begins with '" + string + "' but found + " + senseIndexEntryArray.length);
        }
        return senseIndexEntryArray[0];
    }

    public SenseIndexEntry[] getLemmaEntries(String string) throws RetrievalException {
        return this.getAllEntries(TextTranslator.translateToDatabaseFormat(string) + LEMMA_TERMINATOR);
    }

    public SenseIndexEntry[] getAllEntries(String string) throws RetrievalException {
        SenseIndexEntry[] senseIndexEntryArray;
        try {
            String[] stringArray = super.getLines(string);
            senseIndexEntryArray = new SenseIndexEntry[stringArray.length];
            for (int i = 0; i < senseIndexEntryArray.length; ++i) {
                senseIndexEntryArray[i] = this.parser.parse(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new RetrievalException("Error reading index file: " + iOException.getMessage(), iOException);
        }
        return senseIndexEntryArray;
    }
}

