/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;

public class SenseIndexEntry
implements Comparable {
    private static final String FIELD_DELIMITER = " ";
    private SenseKey senseKey;
    private int synsetOffset;
    private int senseNumber;
    private int tagCount;

    public SenseIndexEntry(SenseKey senseKey, int n, int n2, int n3) {
        this.senseKey = senseKey;
        this.synsetOffset = n;
        this.senseNumber = n2;
        this.tagCount = n3;
    }

    public SynsetPointer getSynsetPointer() {
        return new SynsetPointer(this.senseKey.getType(), this.synsetOffset);
    }

    public SenseKey getSenseKey() {
        return this.senseKey;
    }

    public int getSynsetOffset() {
        return this.synsetOffset;
    }

    public int getSenseNumber() {
        return this.senseNumber;
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object != null) {
            SenseIndexEntry senseIndexEntry = (SenseIndexEntry)object;
            n = this.senseKey.getType().compareTo(senseIndexEntry.getSenseKey().getType());
            if (n == 0 && (n = senseIndexEntry.getTagCount() - this.getTagCount()) == 0 && (n = this.getSenseNumber() - senseIndexEntry.getSenseNumber()) == 0) {
                n = this.getSenseKey().compareTo(senseIndexEntry.getSenseKey());
            }
        }
        return n;
    }

    public String toString() {
        return this.senseKey.toString() + FIELD_DELIMITER + this.pad(this.getSynsetOffset(), 8) + FIELD_DELIMITER + this.getSenseNumber() + FIELD_DELIMITER + this.getTagCount();
    }

    private String pad(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }
}

