/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class SampleSentenceData {
    private static final char KEY_TERMINATOR = ' ';
    private Map typeMaps = new HashMap();
    private ResourceBundle bundle;

    protected SampleSentenceData() {
    }

    protected Object getValue(SynsetType synsetType, Object object) {
        Map map = this.getSubMap(synsetType);
        return map != null ? map.get(object) : null;
    }

    private synchronized Map getSubMap(SynsetType synsetType) throws RetrievalException {
        Map map;
        if (!this.typeMaps.containsKey(synsetType)) {
            map = this.loadData(synsetType);
            this.typeMaps.put(synsetType, map);
        } else {
            map = (Map)this.typeMaps.get(synsetType);
        }
        return map;
    }

    private Map loadData(SynsetType synsetType) throws RetrievalException {
        Map map = null;
        String string = this.getFileName(synsetType);
        if (string != null) {
            try {
                map = this.createMap(string);
            }
            catch (IOException iOException) {
                throw new RetrievalException("Error reading file " + string + ": " + iOException.getMessage(), iOException);
            }
        }
        return map;
    }

    private String getFileName(SynsetType synsetType) {
        String string;
        ResourceBundle resourceBundle = this.getBundle();
        try {
            string = resourceBundle.getString(Integer.toString(synsetType.getCode()));
        }
        catch (MissingResourceException missingResourceException) {
            string = null;
        }
        return string;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(this.getResourceBundleName());
        }
        return this.bundle;
    }

    protected String getResourceBundleName() {
        return this.getClass().getName();
    }

    private Map createMap(String string) throws IOException {
        HashMap hashMap = new HashMap();
        File file = new File(System.getProperty("wordnet.database.dir", "."), string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            int n = string2.indexOf(32);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1).trim();
            this.putKeyValuePair(hashMap, string3, string4);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return hashMap;
    }

    protected void putKeyValuePair(Map map, String string, String string2) {
        map.put(string, string2);
    }
}

