/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.WordSensePointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationshipPointers {
    private static final String SYNSET_KEY = "*";
    private Map sourceMaps = new HashMap();

    public void addSemanticRelationship(RelationshipType relationshipType, SynsetPointer synsetPointer) {
        this.add(SYNSET_KEY, relationshipType, synsetPointer);
    }

    public void addLexicalRelationship(String string, RelationshipType relationshipType, WordSensePointer wordSensePointer) {
        this.add(string, relationshipType, wordSensePointer);
    }

    private void add(Object object, RelationshipType relationshipType, Object object2) {
        Map map = this.getSubMap(object, true);
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(relationshipType);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put(relationshipType, arrayList);
        }
        arrayList.add(object2);
    }

    public SynsetPointer[] getSemanticRelationships(RelationshipType relationshipType) {
        List list;
        SynsetPointer[] synsetPointerArray = null;
        Map map = this.getSubMap(SYNSET_KEY, false);
        if (map != null && (list = (List)map.get(relationshipType)) != null) {
            synsetPointerArray = new SynsetPointer[list.size()];
            list.toArray(synsetPointerArray);
        }
        return synsetPointerArray != null ? synsetPointerArray : new SynsetPointer[]{};
    }

    public WordSensePointer[] getLexicalRelationships(String string, RelationshipType relationshipType) {
        List list;
        WordSensePointer[] wordSensePointerArray = null;
        Map map = this.getSubMap(string, false);
        if (map != null && (list = (List)map.get(relationshipType)) != null) {
            wordSensePointerArray = new WordSensePointer[list.size()];
            list.toArray(wordSensePointerArray);
        }
        return wordSensePointerArray != null ? wordSensePointerArray : new WordSensePointer[]{};
    }

    public boolean removeAllSemanticRelationships(RelationshipType relationshipType) {
        return this.removeAll(SYNSET_KEY, relationshipType);
    }

    public boolean removeAllLexicalRelationships(String string, RelationshipType relationshipType) {
        return this.removeAll(string, relationshipType);
    }

    private boolean removeAll(Object object, RelationshipType relationshipType) {
        boolean bl = false;
        Map map = this.getSubMap(object, false);
        if (map != null) {
            bl = map.remove(object) != null;
        }
        return bl;
    }

    private Map getSubMap(Object object, boolean bl) {
        HashMap hashMap = (HashMap)this.sourceMaps.get(object);
        if (hashMap == null && bl) {
            hashMap = new HashMap();
            this.sourceMaps.put(object, hashMap);
        }
        return hashMap;
    }
}

