/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SynsetTypeConverter;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class InflectionData {
    private static final String WORD_DELIMITER = " ";
    private static final ResourceBundle TYPE_FILES = ResourceBundle.getBundle((class$edu$smu$tspell$wordnet$impl$file$InflectionData == null ? (class$edu$smu$tspell$wordnet$impl$file$InflectionData = InflectionData.class$("edu.smu.tspell.wordnet.impl.file.InflectionData")) : class$edu$smu$tspell$wordnet$impl$file$InflectionData).getName());
    private static InflectionData instance;
    private Map inflectionMaps = new HashMap();
    static /* synthetic */ Class class$edu$smu$tspell$wordnet$impl$file$InflectionData;

    public static synchronized InflectionData getInstance() {
        if (instance == null) {
            instance = new InflectionData();
        }
        return instance;
    }

    private InflectionData() throws RetrievalException {
        this.loadExceptions();
    }

    private void loadExceptions() throws RetrievalException {
        Enumeration<String> enumeration = TYPE_FILES.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            int n = Integer.parseInt(string);
            String string2 = TYPE_FILES.getString(string);
            SynsetType synsetType = SynsetTypeConverter.getType(n);
            try {
                this.loadExceptions(string2, synsetType);
            }
            catch (IOException iOException) {
                throw new RetrievalException("Error reading exceptions from file " + string2 + ": " + iOException.getMessage(), iOException);
            }
        }
    }

    private void loadExceptions(String string, SynsetType synsetType) throws IOException {
        String string2 = System.getProperty("wordnet.database.dir", ".");
        File file = new File(string2, string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, WORD_DELIMITER);
            String string4 = TextTranslator.translateToExternalFormat(stringTokenizer.nextToken());
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = TextTranslator.translateToExternalFormat(stringTokenizer.nextToken());
            }
            this.putMorphology(string4, stringArray, synsetType);
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    private void putMorphology(String string, String[] stringArray, SynsetType synsetType) {
        Map map = this.getSubMap(string, true);
        map.put(synsetType, stringArray);
    }

    public String[] getBaseForms(String string, SynsetType synsetType) {
        String[] stringArray = null;
        Map map = this.getSubMap(string, false);
        if (map != null) {
            stringArray = (String[])map.get(synsetType);
        }
        return stringArray != null ? stringArray : new String[]{};
    }

    private Map getSubMap(String string, boolean bl) {
        String string2 = string.toLowerCase();
        TreeMap treeMap = (TreeMap)this.inflectionMaps.get(string2);
        if (treeMap == null && bl) {
            treeMap = new TreeMap();
            this.inflectionMaps.put(string2, treeMap);
        }
        return treeMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

