/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DetachmentRules {
    private static final RuleOfDetachment[] NOUN_RULES_OF_DETACHMENT = new RuleOfDetachment[]{new RuleOfDetachment("s", ""), new RuleOfDetachment("ses", "s"), new RuleOfDetachment("xes", "x"), new RuleOfDetachment("zes", "z"), new RuleOfDetachment("ches", "ch"), new RuleOfDetachment("shes", "sh"), new RuleOfDetachment("men", "man"), new RuleOfDetachment("ies", "y")};
    private static final RuleOfDetachment[] VERB_RULES_OF_DETACHMENT = new RuleOfDetachment[]{new RuleOfDetachment("s", ""), new RuleOfDetachment("ies", "y"), new RuleOfDetachment("es", "e"), new RuleOfDetachment("es", ""), new RuleOfDetachment("ed", "e"), new RuleOfDetachment("ed", ""), new RuleOfDetachment("ing", "e"), new RuleOfDetachment("ing", "")};
    private static final RuleOfDetachment[] ADJECTIVE_RULES_OF_DETACHMENT = new RuleOfDetachment[]{new RuleOfDetachment("er", ""), new RuleOfDetachment("est", ""), new RuleOfDetachment("er", ""), new RuleOfDetachment("er", "")};
    private static final RuleOfDetachment[] ADVERB_RULES_OF_DETACHMENT = new RuleOfDetachment[0];
    private static final Map CATEGORY_RULES = new HashMap();
    private static DetachmentRules instance;

    public static synchronized DetachmentRules getInstance() {
        if (instance == null) {
            instance = new DetachmentRules();
        }
        return instance;
    }

    private DetachmentRules() {
    }

    public String[] getCandidateForms(String string, SynsetType synsetType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RuleOfDetachment[] ruleOfDetachmentArray = this.getRulesOfDetachment(synsetType);
        for (int i = 0; i < ruleOfDetachmentArray.length; ++i) {
            String string2 = ruleOfDetachmentArray[i].getSuffix();
            if (!string.endsWith(string2)) continue;
            String string3 = string.substring(0, string.length() - string2.length()) + ruleOfDetachmentArray[i].getEnding();
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private RuleOfDetachment[] getRulesOfDetachment(SynsetType synsetType) {
        RuleOfDetachment[] ruleOfDetachmentArray = (RuleOfDetachment[])CATEGORY_RULES.get(synsetType);
        return ruleOfDetachmentArray != null ? ruleOfDetachmentArray : new RuleOfDetachment[]{};
    }

    static {
        CATEGORY_RULES.put(SynsetType.NOUN, NOUN_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.VERB, VERB_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.ADJECTIVE, ADJECTIVE_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.ADVERB, ADVERB_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.ADJECTIVE_SATELLITE, ADJECTIVE_RULES_OF_DETACHMENT);
    }

    private static class RuleOfDetachment {
        private String suffix;
        private String ending;

        public RuleOfDetachment(String string, String string2) {
            this.suffix = string;
            this.ending = string2;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getEnding() {
            return this.ending;
        }
    }
}

