/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class RandomAccessReader {
    protected static final char LINE_SEPARATOR = '\n';
    protected static final String ACCESS_MODE = "r";
    protected RandomAccessFile accessor;
    private long fileSize;
    private long filePointer;

    protected RandomAccessReader(File file) throws IOException {
        this.accessor = new RandomAccessFile(file, ACCESS_MODE);
        this.fileSize = file.length();
        this.filePointer = this.accessor.getFilePointer();
    }

    protected synchronized void seek(long l) throws IOException {
        if (l != this.filePointer) {
            RandomAccessFile randomAccessFile = this.getAccessor();
            randomAccessFile.seek(l);
            this.filePointer = l;
        }
    }

    protected synchronized String readToNextEndOfLine() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.filePointer < this.fileSize && (c = this.readNextCharacter()) != '\n') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected synchronized char readNextCharacter() throws IOException {
        char c = '\uffff';
        if (this.filePointer < this.fileSize) {
            c = (char)this.accessor.read();
            ++this.filePointer;
        }
        return c;
    }

    protected RandomAccessFile getAccessor() {
        return this.accessor;
    }

    protected long getFileSize() {
        return this.fileSize;
    }

    protected long getFilePointer() {
        return this.filePointer;
    }

    protected void finalize() throws Throwable {
        try {
            RandomAccessFile randomAccessFile = this.getAccessor();
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error closing file: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

