/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.api.server.spi.config.Nullable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.app.DataPointRequest;
import org.akvo.flow.api.app.DataPointResponse;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.app.web.dto.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class DataPointServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(DataPointServlet.class.getName());
    private SurveyedLocaleDao surveyedLocaleDao;
    private DataPointAssignmentDao dataPointAssignmentDao;

    public DataPointServlet() {
        this.setMode("JSON");
        this.surveyedLocaleDao = new SurveyedLocaleDao();
        this.dataPointAssignmentDao = new DataPointAssignmentDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataPointRequest restRequest = new DataPointRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DataPointRequest dpReq = (DataPointRequest)req;
        RestResponse res = new RestResponse();
        if (dpReq.getSurveyId() != null) {
            DeviceDAO deviceDao = new DeviceDAO();
            Device device = deviceDao.getDevice(dpReq.getAndroidId(), dpReq.getImei(), dpReq.getPhoneNumber());
            if (device != null) {
                log.info("Found device id: " + device.getKey().getId());
                log.fine("Found device: " + device);
                List<DataPointAssignment> assList = this.dataPointAssignmentDao.listByDeviceAndSurvey(device.getKey().getId(), dpReq.getSurveyId());
                HashSet<Long> pointSet = new HashSet<Long>();
                for (DataPointAssignment ass : assList) {
                    pointSet.addAll(ass.getDataPointIds());
                }
                ArrayList<Long> pointList = new ArrayList<Long>();
                pointList.addAll(pointSet);
                List<SurveyedLocale> dpList = this.surveyedLocaleDao.listByKeys(pointList);
                res = this.convertToResponse(dpList, dpReq.getSurveyId());
                return res;
            }
            res.setCode(String.valueOf(404));
            res.setMessage("Unknown device");
        } else {
            res.setCode(String.valueOf(403));
            res.setMessage("Invalid Survey");
        }
        return res;
    }

    private DataPointResponse convertToResponse(List<SurveyedLocale> slList, Long surveyId) {
        DataPointResponse resp = new DataPointResponse();
        if (slList == null) {
            resp.setCode(String.valueOf(500));
            resp.setMessage("Internal Server Error");
            return resp;
        }
        resp.setCode(String.valueOf(200));
        resp.setResultCount(slList.size());
        List<SurveyedLocaleDto> dtoList = DataPointServlet.getSurveyedLocaleDtosList(slList, surveyId);
        resp.setDataPointData(dtoList);
        return resp;
    }

    protected static List<SurveyedLocaleDto> getSurveyedLocaleDtosList(List<SurveyedLocale> slList, Long surveyId) {
        ArrayList<SurveyedLocaleDto> dtoList = new ArrayList<SurveyedLocaleDto>();
        HashMap<Long, String> questionTypeMap = new HashMap<Long, String>();
        QuestionDao questionDao = new QuestionDao();
        List<Long> surveyedLocalesIds = DataPointServlet.getSurveyedLocalesIds(slList);
        Map<Long, List<SurveyInstance>> surveyInstancesMap = DataPointServlet.getSurveyInstances(surveyedLocalesIds);
        Map<Long, List<QuestionAnswerStore>> questionAnswerStore = DataPointServlet.getQuestionAnswerStoreMap(surveyInstancesMap);
        for (SurveyedLocale surveyedLocale : slList) {
            long surveyedLocaleId = surveyedLocale.getKey().getId();
            SurveyedLocaleDto dto = DataPointServlet.createSurveyedLocaleDto(surveyId, questionDao, questionTypeMap, surveyedLocale, questionAnswerStore, surveyInstancesMap.get(surveyedLocaleId));
            dtoList.add(dto);
        }
        return dtoList;
    }

    private static SurveyedLocaleDto createSurveyedLocaleDto(Long surveyGroupId, QuestionDao questionDao, HashMap<Long, String> questionTypeMap, SurveyedLocale surveyedLocale, Map<Long, List<QuestionAnswerStore>> questionAnswerStoreMap, @Nullable List<SurveyInstance> surveyInstances) {
        SurveyedLocaleDto dto = new SurveyedLocaleDto();
        dto.setId(surveyedLocale.getIdentifier());
        dto.setSurveyGroupId(surveyGroupId);
        dto.setDisplayName(surveyedLocale.getDisplayName());
        dto.setLat(surveyedLocale.getLatitude());
        dto.setLon(surveyedLocale.getLongitude());
        dto.setLastUpdateDateTime(surveyedLocale.getLastUpdateDateTime());
        if (surveyInstances != null) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                Long surveyInstanceId = surveyInstance.getObjectId();
                List<QuestionAnswerStore> answerStores = questionAnswerStoreMap.get(surveyInstanceId);
                SurveyInstanceDto siDto = DataPointServlet.createSurveyInstanceDto(questionDao, questionTypeMap, answerStores, surveyInstance);
                dto.getSurveyInstances().add(siDto);
            }
        }
        return dto;
    }

    private static Map<Long, List<QuestionAnswerStore>> getQuestionAnswerStoreMap(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        QuestionAnswerStoreDao questionAnswerStoreDao = new QuestionAnswerStoreDao();
        List<Long> surveyInstancesIds = DataPointServlet.getSurveyInstancesIds(surveyInstanceMap);
        List questionAnswerList = questionAnswerStoreDao.fetchItemsByIdBatches(surveyInstancesIds, "surveyInstanceId");
        HashMap<Long, List<QuestionAnswerStore>> questionAnswerStoreMap = new HashMap<Long, List<QuestionAnswerStore>>();
        if (questionAnswerList != null && questionAnswerList.size() > 0) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerList) {
                Long surveyInstanceId = questionAnswerStore.getSurveyInstanceId();
                if (questionAnswerStoreMap.containsKey(surveyInstanceId)) {
                    ((List)questionAnswerStoreMap.get(surveyInstanceId)).add(questionAnswerStore);
                    continue;
                }
                ArrayList<QuestionAnswerStore> questionAnswerStores = new ArrayList<QuestionAnswerStore>();
                questionAnswerStores.add(questionAnswerStore);
                questionAnswerStoreMap.put(surveyInstanceId, questionAnswerStores);
            }
        }
        return questionAnswerStoreMap;
    }

    private static List<Long> getSurveyInstancesIds(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        ArrayList<Long> surveyInstancesIds = new ArrayList<Long>();
        Collection<List<SurveyInstance>> values = surveyInstanceMap.values();
        for (List<SurveyInstance> surveyInstances : values) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                surveyInstancesIds.add(surveyInstance.getObjectId());
            }
        }
        return surveyInstancesIds;
    }

    private static Map<Long, List<SurveyInstance>> getSurveyInstances(List<Long> surveyedLocalesIds) {
        SurveyInstanceDAO surveyInstanceDAO = new SurveyInstanceDAO();
        List values = surveyInstanceDAO.fetchItemsByIdBatches(surveyedLocalesIds, "surveyedLocaleId");
        HashMap<Long, List<SurveyInstance>> surveyInstancesMap = new HashMap<Long, List<SurveyInstance>>();
        for (SurveyInstance surveyInstance : values) {
            Long surveyedLocaleId = surveyInstance.getSurveyedLocaleId();
            if (surveyInstancesMap.containsKey(surveyedLocaleId)) {
                ((List)surveyInstancesMap.get(surveyedLocaleId)).add(surveyInstance);
                continue;
            }
            ArrayList<SurveyInstance> instances = new ArrayList<SurveyInstance>();
            instances.add(surveyInstance);
            surveyInstancesMap.put(surveyedLocaleId, instances);
        }
        return surveyInstancesMap;
    }

    private static List<Long> getSurveyedLocalesIds(List<SurveyedLocale> slList) {
        if (slList == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> surveyedLocaleIds = new ArrayList<Long>(slList.size());
        for (SurveyedLocale surveyedLocale : slList) {
            surveyedLocaleIds.add(surveyedLocale.getKey().getId());
        }
        return surveyedLocaleIds;
    }

    private static SurveyInstanceDto createSurveyInstanceDto(QuestionDao qDao, HashMap<Long, String> questionTypeMap, @Nullable List<QuestionAnswerStore> questionAnswerStores, @Nullable SurveyInstance surveyInstance) {
        SurveyInstanceDto surveyInstanceDto = new SurveyInstanceDto();
        if (surveyInstance != null) {
            surveyInstanceDto.setUuid(surveyInstance.getUuid());
            surveyInstanceDto.setSubmitter(surveyInstance.getSubmitterName());
            surveyInstanceDto.setSurveyId(surveyInstance.getSurveyId());
            surveyInstanceDto.setCollectionDate(surveyInstance.getCollectionDate().getTime());
        }
        if (questionAnswerStores != null) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerStores) {
                Long questionId = questionAnswerStore.getQuestionIDLong();
                if (questionId == null) continue;
                String type = DataPointServlet.getQuestionType(qDao, questionTypeMap, questionAnswerStore);
                String value = DataPointServlet.getAnswerValue(questionAnswerStore, type);
                surveyInstanceDto.addProperty(questionId, value, type);
            }
        }
        return surveyInstanceDto;
    }

    private static String getAnswerValue(QuestionAnswerStore questionAnswerStore, String type) {
        String answerValue = questionAnswerStore.getValue();
        String value = answerValue != null ? answerValue : "";
        switch (type) {
            case "OPTION": 
            case "OTHER": {
                if (!value.startsWith("[")) break;
                value = DataUtils.jsonResponsesToPipeSeparated(value);
                break;
            }
            case "IMAGE": 
            case "VIDEO": {
                value = MediaResponse.format(value, 0);
                break;
            }
        }
        return value;
    }

    private static String getQuestionType(QuestionDao questionDao, HashMap<Long, String> questionTypeMap, QuestionAnswerStore questionAnswerStore) {
        String type = questionAnswerStore.getType();
        if (type == null || "".equals(type)) {
            type = "VALUE";
        } else if ("PHOTO".equals(type)) {
            type = "IMAGE";
        } else if ("OPTION".equals(type)) {
            Long questionId = questionAnswerStore.getQuestionIDLong();
            if (questionTypeMap.containsKey(questionId)) {
                type = questionTypeMap.get(questionId);
            } else {
                Question question = questionDao.getByKey(questionId);
                if (question != null) {
                    if (question.getAllowOtherFlag().booleanValue()) {
                        type = "OTHER";
                    }
                    questionTypeMap.put(questionId, type);
                }
            }
        }
        return type;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
            ServletOutputStream stream = this.getResponse().getOutputStream();
            writer.writeValue((OutputStream)stream, resp);
            PrintWriter endwriter = new PrintWriter((OutputStream)stream);
            endwriter.println();
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

