/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import javax.servlet.http.HttpServletRequest;

public class SpreadsheetImportRequest
extends RestRequest {
    private static final long serialVersionUID = 8472898722818764987L;
    public static final String PROCESS_FILE_ACTION = "processFile";
    private static final String ID_PARAM = "identifier";
    private static final String TYPE_PARAM = "type";
    private static final String START_ROW_PARAM = "startRow";
    private static final String GROUP_ID_PARAM = "questionGroupId";
    private static final String ST_PARAM = "sessionToken";
    private String identifier;
    private String type;
    private int startRow = 0;
    private long groupId;
    private byte[] key = null;
    private String keySpec = null;
    private String sessionToken;

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public int getStartRow() {
        return this.startRow;
    }

    @Override
    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.identifier = req.getParameter(ID_PARAM);
        this.type = req.getParameter(TYPE_PARAM);
        this.sessionToken = req.getParameter(ST_PARAM);
        this.key = req.getParameter("privateKey").getBytes();
        this.keySpec = req.getParameter("keySpec");
        String start = req.getParameter(START_ROW_PARAM);
        String groupId = req.getParameter(GROUP_ID_PARAM);
        if (start != null) {
            try {
                this.startRow = Integer.parseInt(start);
            }
            catch (NumberFormatException e) {
                this.addError(new RestError("5002", "Invalid data type", "Start row must be an integer"));
            }
        }
        if (groupId != null) {
            try {
                this.groupId = Long.parseLong(groupId);
            }
            catch (NumberFormatException e) {
                this.addError(new RestError("5002", "Invalid data type", "GroupId must be an integer"));
            }
        }
    }

    @Override
    public void populateErrors() {
        if (this.getAction() == null) {
            String errorMsg = "action is mandatory";
            this.addError(new RestError("5001", "Missing mandatory parameter", errorMsg));
        }
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKeySpec(String keySpec) {
        this.keySpec = keySpec;
    }

    public String getKeySpec() {
        return this.keySpec;
    }
}

