/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.QuestionHelpMediaDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.dto.SurveyTaskRequest;

public class SurveyTaskServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(SurveyTaskServlet.class.getName());
    private static final long serialVersionUID = -9064136783930675167L;

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyTaskRequest restRequest = new SurveyTaskRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        SurveyTaskRequest stReq = (SurveyTaskRequest)req;
        String action = stReq.getAction();
        Long id = stReq.getId();
        log.info("action: " + action + " id: " + id);
        if (action == null) {
            return null;
        }
        switch (action) {
            case "deleteSurvey": {
                SurveyDAO surveyDao = new SurveyDAO();
                Survey s = (Survey)surveyDao.getByKey(id);
                if (s == null) break;
                surveyDao.delete(s);
                break;
            }
            case "deleteQuestionGroup": {
                QuestionGroupDao qgDao = new QuestionGroupDao();
                QuestionGroup qg = (QuestionGroup)qgDao.getByKey(id);
                if (qg == null) break;
                qgDao.delete(qg);
                break;
            }
            case "deleteQuestion": {
                QuestionDao qDao = new QuestionDao();
                Question q = qDao.getByKey(id);
                if (q == null) break;
                qDao.delete(q);
                break;
            }
            case "deleteQuestionOptions": {
                QuestionOptionDao qoDao = new QuestionOptionDao();
                qoDao.delete(qoDao.getByKey(id));
                break;
            }
            case "deleteQuestionHelp": {
                QuestionHelpMediaDao qhDao = new QuestionHelpMediaDao();
                qhDao.delete(qhDao.getByKey(id));
                break;
            }
            case "deleteQuestionTranslation": {
                TranslationDao tDao = new TranslationDao();
                tDao.delete(tDao.getByKey(id));
                break;
            }
            case "deleteDeviceSurveyJobQueue": {
                DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
                dsjqDao.deleteJob(id);
                break;
            }
            case "deleteDeviceFileJobQueue": {
                DeviceFileJobQueueDAO dfjqDao = new DeviceFileJobQueueDAO();
                dfjqDao.delete(dfjqDao.getByKey(id));
                break;
            }
            default: {
                log.warning("Unknown action.");
            }
        }
        return null;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }
}

