/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.servlet;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.common.util.PropertyUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class RestAuthFilter
implements Filter {
    private static final long MAX_TIME = 600000L;
    private static final Logger log = Logger.getLogger(RestAuthFilter.class.getName());
    private static final String ENABLED_PROP = "enableRestSecurity";
    private static final String REST_PRIVATE_KEY_PROP = "restPrivateKey";
    private String privateKey;
    private boolean isEnabled = false;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block5: {
            if (this.isEnabled) {
                try {
                    if (this.isAuthorized(req)) {
                        chain.doFilter(req, res);
                        break block5;
                    }
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.sendError(401, "Authorization failed");
                }
                catch (Exception e) {
                    log.severe("Auth failure " + e.getMessage());
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.sendError(401, "Authorization failed");
                }
            } else {
                chain.doFilter(req, res);
            }
        }
    }

    private boolean isAuthorized(ServletRequest req) throws Exception {
        Map paramMap = req.getParameterMap();
        String incomingHash = null;
        long incomingTimestamp = 0L;
        ArrayList names = new ArrayList();
        if (paramMap != null) {
            names.addAll(paramMap.keySet());
            Collections.sort(names);
            StringBuilder builder = new StringBuilder();
            for (String name : names) {
                if (!"h".equals(name)) {
                    if (builder.length() > 0) {
                        builder.append("&");
                    }
                    if ("ts".equals(name)) {
                        String timestamp = ((String[])paramMap.get(name))[0];
                        try {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            df.setTimeZone(TimeZone.getTimeZone("GMT"));
                            incomingTimestamp = df.parse(timestamp).getTime();
                        }
                        catch (Exception e) {
                            log.warning("Recived rest api request with invalid timestamp");
                            return false;
                        }
                    }
                    String[] vals = (String[])paramMap.get(name);
                    int count = 0;
                    for (String v : vals) {
                        if (count > 0) {
                            builder.append("&");
                        }
                        builder.append(name).append("=").append(URLEncoder.encode(v, "UTF-8"));
                        ++count;
                    }
                    continue;
                }
                incomingHash = ((String[])paramMap.get(name))[0];
                incomingHash = incomingHash.replaceAll(" ", "+");
            }
            if (incomingHash != null) {
                String ourHash = MD5Util.generateHMAC(builder.toString(), this.privateKey);
                if (ourHash == null) {
                    return false;
                }
                if (ourHash.equals(incomingHash)) {
                    return this.isTimestampValid(incomingTimestamp);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean isTimestampValid(long theirTime) {
        long time = System.currentTimeMillis();
        return Math.abs(time - theirTime) <= 600000L;
    }

    public void init(FilterConfig arg) throws ServletException {
        String enabledFlag = PropertyUtil.getProperty(ENABLED_PROP);
        if (enabledFlag != null) {
            try {
                this.isEnabled = Boolean.parseBoolean(enabledFlag.trim());
            }
            catch (Exception e) {
                log.severe("Could not parse enableRestSecurity value of " + enabledFlag);
                this.isEnabled = false;
            }
        }
        this.privateKey = PropertyUtil.getProperty(REST_PRIVATE_KEY_PROP);
    }

    public void destroy() {
    }
}

