/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.rest;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.exception.RestValidationException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public abstract class RestRequest
implements Serializable {
    private static final long serialVersionUID = -8356057661356968219L;
    public static final String ACTION_PARAM = "action";
    private static final String STARTROW_PARAM = "startRow";
    private static final String ENDROW_PARAM = "endRow";
    public static final String CURSOR_PARAM = "cursor";
    private static final String DESIRED_RESULTS_PARAM = "maxResults";
    private static final String NULL_STRING = "null";
    public static final String API_KEY_PARAM = "k";
    public static final String HASH_PARAM = "h";
    public static final String TIMESTAMP_PARAM = "ts";
    private List<RestError> validationErrorList;
    private int startRow;
    private int endRow;
    private int desiredResults;
    private String action;
    private String apiKey;
    private String hash;
    private Date timestamp;
    private String cursor;

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void populateFromHttpRequest(HttpServletRequest servletRequest) throws Exception {
        this.setAction(servletRequest.getParameter(ACTION_PARAM));
        this.setApiKey(servletRequest.getParameter(API_KEY_PARAM));
        this.setHash(servletRequest.getParameter(HASH_PARAM));
        if (servletRequest.getParameter(TIMESTAMP_PARAM) != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.setTimestamp(df.parse(servletRequest.getParameter(TIMESTAMP_PARAM)));
            }
            catch (Exception e) {
                this.addError(new RestError("5002", "Invalid data type", "ts must be an w3c date"));
            }
        }
        this.cursor = servletRequest.getParameter(CURSOR_PARAM);
        if (this.cursor != null && (NULL_STRING.equalsIgnoreCase(this.cursor.trim()) || this.cursor.trim().length() == 0)) {
            this.cursor = null;
        }
        this.setStartRow(this.stringToInt(servletRequest.getParameter(STARTROW_PARAM)));
        this.setEndRow(this.stringToInt(servletRequest.getParameter(ENDROW_PARAM)));
        this.setDesiredResults(this.stringToInt(servletRequest.getParameter(DESIRED_RESULTS_PARAM)));
        this.populateFields(servletRequest);
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public List<RestError> getValidationErrorList() {
        return this.validationErrorList;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getDesiredResults() {
        return this.desiredResults;
    }

    public void setDesiredResults(int desiredResults) {
        this.desiredResults = desiredResults;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private int stringToInt(String val) {
        int intVal = -1;
        if (val != null) {
            intVal = Integer.parseInt(val);
        }
        return intVal;
    }

    protected void addError(RestError err) {
        if (this.validationErrorList == null) {
            this.validationErrorList = new ArrayList<RestError>();
        }
        this.validationErrorList.add(err);
    }

    protected abstract void populateFields(HttpServletRequest var1) throws Exception;

    protected abstract void populateErrors();

    public void validate() throws RestValidationException {
        this.populateErrors();
        if (this.validationErrorList != null && this.validationErrorList.size() > 0) {
            throw new RestValidationException(this.validationErrorList, "Validation error", null);
        }
    }

    protected Long parseLong(String val, String field) {
        Long result = null;
        if (val != null && val.trim().length() > 0) {
            try {
                result = Long.parseLong(val);
            }
            catch (Exception e) {
                this.addError(new RestError("5002", "Invalid data type", field + " must be an integer"));
            }
        }
        return result;
    }
}

