/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.security;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.akvo.flow.rest.security.AppRole;
import org.akvo.flow.rest.security.user.ApiUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class ApiUserAuthentication
implements Authentication {
    private static final long serialVersionUID = 7982388231754113238L;
    private ApiUser principal;
    private Map<String, String> details;
    private boolean authenticated;
    private Long userId;

    public ApiUserAuthentication(ApiUser principal, Map<String, String> details) {
        this.principal = principal;
        this.details = details;
        this.authenticated = true;
    }

    public ApiUserAuthentication(ApiUser principal) {
        this.principal = principal;
        this.details = null;
        this.authenticated = true;
        this.userId = principal.getUserId();
    }

    public String getName() {
        return this.principal.getUserName();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return EnumSet.of(AppRole.ROLE_USER);
    }

    public Object getCredentials() {
        return this.userId;
    }

    public Object getDetails() {
        return this.details;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) throws IllegalArgumentException {
        this.authenticated = authenticated;
    }
}

