/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.DataExporter;
import com.gallatinsystems.framework.dataexport.applet.DataImportExportFactory;
import com.gallatinsystems.framework.dataexport.applet.DataImporter;
import java.util.HashMap;
import java.util.Map;
import org.waterforpeople.mapping.dataexport.GraphicalSurveySummaryExporter;
import org.waterforpeople.mapping.dataexport.RawDataSpreadsheetImporter;
import org.waterforpeople.mapping.dataexport.SurveyFormExporter;
import org.waterforpeople.mapping.dataexport.SurveySpreadsheetImporter;
import org.waterforpeople.mapping.dataexport.SurveySummaryExporter;

public class SurveyDataImportExportFactory
implements DataImportExportFactory {
    private static final Map<String, Class<? extends DataExporter>> EXPORTER_MAP = new HashMap<String, Class<? extends DataExporter>>(){
        private static final long serialVersionUID = 6562869574473763867L;
        {
            this.put("SURVEY_SUMMARY", SurveySummaryExporter.class);
            this.put("DATA_CLEANING", GraphicalSurveySummaryExporter.class);
            this.put("DATA_ANALYSIS", GraphicalSurveySummaryExporter.class);
            this.put("COMPREHENSIVE", GraphicalSurveySummaryExporter.class);
            this.put("SURVEY_FORM", SurveyFormExporter.class);
        }
    };
    private static final Map<String, Class<? extends DataImporter>> IMPORTER_MAP = new HashMap<String, Class<? extends DataImporter>>(){
        private static final long serialVersionUID = 6562869574473763867L;
        {
            this.put("SURVEY_SPREADSHEET", SurveySpreadsheetImporter.class);
            this.put("RAW_DATA", RawDataSpreadsheetImporter.class);
        }
    };

    @Override
    public DataExporter getExporter(String type) {
        Class<? extends DataExporter> exporterClass = EXPORTER_MAP.get(type);
        if (exporterClass != null) {
            try {
                return exporterClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize constructor");
            }
        }
        throw new RuntimeException("Unknown Exporter Type: " + type);
    }

    @Override
    public DataImporter getImporter(String type) {
        Class<? extends DataImporter> importerClass = IMPORTER_MAP.get(type);
        if (importerClass != null) {
            try {
                return importerClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize constructor");
            }
        }
        throw new RuntimeException("Unknown Importer Type: " + type);
    }
}

