/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import org.akvo.flow.xml.XmlAltText;
import org.akvo.flow.xml.XmlDependency;
import org.akvo.flow.xml.XmlHelp;
import org.akvo.flow.xml.XmlLevel;
import org.akvo.flow.xml.XmlOptions;
import org.akvo.flow.xml.XmlValidationRule;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;

public class XmlQuestion {
    private static String FREE_TYPE = "free";
    private static String NUMERIC_VALIDATION_TYPE = "numeric";
    @JacksonXmlProperty(localName="options", isAttribute=false)
    private XmlOptions options;
    @JacksonXmlProperty(localName="validationRule", isAttribute=false)
    private XmlValidationRule validationRule;
    @JacksonXmlProperty(localName="dependency", isAttribute=false)
    private XmlDependency dependency;
    @JacksonXmlProperty(localName="help", isAttribute=false)
    private XmlHelp help;
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private XmlAltText[] altText;
    @JacksonXmlProperty(localName="text", isAttribute=false)
    private String text;
    @JacksonXmlElementWrapper(localName="levels", useWrapping=true)
    private XmlLevel[] level;
    @JacksonXmlProperty(localName="id", isAttribute=true)
    private long id;
    @JacksonXmlProperty(localName="order", isAttribute=true)
    private int order;
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private String type;
    @JacksonXmlProperty(localName="mandatory", isAttribute=true)
    private boolean mandatory;
    @JacksonXmlProperty(localName="requireDoubleEntry", isAttribute=true)
    private boolean requireDoubleEntry;
    @JacksonXmlProperty(localName="localeNameFlag", isAttribute=true)
    private boolean localeNameFlag;
    @JacksonXmlProperty(localName="locked", isAttribute=true)
    private boolean locked;
    @JacksonXmlProperty(localName="localeLocationFlag", isAttribute=true)
    private boolean localeLocationFlag;
    @JacksonXmlProperty(localName="caddisflyResourceUuid", isAttribute=true)
    private String caddisflyResourceUuid;
    @JacksonXmlProperty(localName="cascadeResource", isAttribute=true)
    private String cascadeResource;
    @JacksonXmlProperty(localName="allowPoints", isAttribute=true)
    private boolean allowPoints;
    @JacksonXmlProperty(localName="allowLine", isAttribute=true)
    private boolean allowLine;
    @JacksonXmlProperty(localName="allowPolygon", isAttribute=true)
    private boolean allowPolygon;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean getLocaleNameFlag() {
        return this.localeNameFlag;
    }

    public void setLocaleNameFlag(boolean localeNameFlag) {
        this.localeNameFlag = localeNameFlag;
    }

    public XmlAltText[] getAltText() {
        return this.altText;
    }

    public void setAltText(XmlAltText[] altText) {
        this.altText = altText;
    }

    public XmlOptions getOptions() {
        return this.options;
    }

    public void setOptions(XmlOptions options) {
        this.options = options;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isLocaleLocationFlag() {
        return this.localeLocationFlag;
    }

    public void setLocaleLocationFlag(boolean localeLocationFlag) {
        this.localeLocationFlag = localeLocationFlag;
    }

    public String getCaddisflyResourceUuid() {
        return this.caddisflyResourceUuid;
    }

    public void setCaddisflyResourceUuid(String caddisflyResourceUuid) {
        this.caddisflyResourceUuid = caddisflyResourceUuid;
    }

    public String getCascadeResource() {
        return this.cascadeResource;
    }

    public void setCascadeResource(String cascadeResource) {
        this.cascadeResource = cascadeResource;
    }

    public XmlValidationRule getValidationRule() {
        return this.validationRule;
    }

    public void setValidationRule(XmlValidationRule validationRule) {
        this.validationRule = validationRule;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean getAllowPoints() {
        return this.allowPoints;
    }

    public void setAllowPoints(boolean allowPoints) {
        this.allowPoints = allowPoints;
    }

    public boolean getAllowLine() {
        return this.allowLine;
    }

    public void setAllowLine(boolean allowLine) {
        this.allowLine = allowLine;
    }

    public boolean getAllowPolygon() {
        return this.allowPolygon;
    }

    public void setAllowPolygon(boolean allowPolygon) {
        this.allowPolygon = allowPolygon;
    }

    public XmlHelp getHelp() {
        return this.help;
    }

    public void setHelp(XmlHelp help) {
        this.help = help;
    }

    public XmlLevel[] getLevel() {
        return this.level;
    }

    public void setLevel(XmlLevel[] level) {
        this.level = level;
    }

    public QuestionDto toDto() {
        QuestionDto.QuestionType t;
        QuestionDto dto = new QuestionDto();
        dto.setKeyId(this.id);
        dto.setText(this.text);
        dto.setOrder(this.order);
        if (FREE_TYPE.equalsIgnoreCase(this.type)) {
            t = this.validationRule != null && NUMERIC_VALIDATION_TYPE.equals(this.validationRule.getValidationType()) ? QuestionDto.QuestionType.NUMBER : QuestionDto.QuestionType.FREE_TEXT;
        } else {
            try {
                t = QuestionDto.QuestionType.valueOf(this.type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                t = QuestionDto.QuestionType.FREE_TEXT;
            }
        }
        dto.setType(t);
        if (this.options != null) {
            dto.setOptionContainerDto(this.options.toDto());
        }
        if (this.level != null) {
            ArrayList<String> cl = new ArrayList<String>();
            for (XmlLevel lvl : this.level) {
                cl.add(lvl.getText());
            }
            dto.setLevelNames(cl);
        }
        if (this.caddisflyResourceUuid != null) {
            dto.setCaddisflyResourceUuid(this.caddisflyResourceUuid);
        }
        return dto;
    }

    public String toString() {
        return "question{id='" + this.id + "',order='" + this.order + "',type='" + this.type + "',mandatory='" + this.mandatory + "',locked='" + this.locked + "',localeNameFlag='" + this.localeNameFlag + "',options=" + (this.options != null ? this.options.toString() : "(null)") + ",level='" + this.level + "'}";
    }
}

