/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.util;

import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.gwt.dto.client.BaseDto;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionHelpMedia;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.weightsmeasures.domain.UnitOfMeasure;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Text;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionHelpDto;
import org.waterforpeople.mapping.app.util.DatastoreTextConverter;
import org.waterforpeople.mapping.app.util.TypeEnumConverter;
import org.waterforpeople.mapping.app.web.dto.OGRFeatureDto;

public class DtoMarshaller {
    public static <T extends BaseDomain, U extends BaseDto> void copyToCanonical(T canonical, U dto) {
        try {
            DtoMarshaller.configureConverters();
            BeanUtils.copyProperties(canonical, dto);
            if (dto.getKeyId() != null) {
                canonical.setKey(KeyFactory.createKey((String)canonical.getClass().getSimpleName(), (long)dto.getKeyId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends BaseDomain, U extends BaseDto> void copyToDto(T canonical, U dto) {
        try {
            DtoMarshaller.configureConverters();
            BeanUtils.copyProperties(dto, canonical);
            if (canonical.getKey() != null) {
                dto.setKeyId(canonical.getKey().getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void configureConverters() {
        String pattern = "MM/dd/yy";
        Locale locale = Locale.getDefault();
        DateLocaleConverter converter = new DateLocaleConverter(locale, pattern);
        converter.setLenient(true);
        ConvertUtils.register((Converter)converter, Date.class);
        TypeEnumConverter enumConverter = new TypeEnumConverter();
        ConvertUtils.register((Converter)enumConverter, Question.Type.class);
        ConvertUtils.register((Converter)enumConverter, QuestionDto.QuestionType.class);
        ConvertUtils.register((Converter)enumConverter, UnitOfMeasure.UnitOfMeasureSystem.class);
        ConvertUtils.register((Converter)enumConverter, UnitOfMeasure.UnitOfMeasureType.class);
        ConvertUtils.register((Converter)enumConverter, QuestionHelpMedia.Type.class);
        ConvertUtils.register((Converter)enumConverter, QuestionHelpDto.Type.class);
        ConvertUtils.register((Converter)enumConverter, OGRFeatureDto.FeatureType.class);
        ConvertUtils.register((Converter)enumConverter, Survey.Status.class);
        ConvertUtils.register((Converter)enumConverter, Survey.Sector.class);
        ConvertUtils.register((Converter)enumConverter, SurveyGroup.ProjectType.class);
        ConvertUtils.register((Converter)enumConverter, SurveyGroup.PrivacyLevel.class);
        ConvertUtils.register((Converter)new DoubleConverter(null), Double.class);
        ConvertUtils.register((Converter)new LongConverter(null), Long.class);
        ConvertUtils.register((Converter)new IntegerConverter(null), Integer.class);
        DatastoreTextConverter textConverter = new DatastoreTextConverter();
        ConvertUtils.register((Converter)textConverter, Text.class);
        ConvertUtils.register((Converter)textConverter, String.class);
    }
}

