/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.user.domain.User;
import com.google.appengine.api.utils.SystemProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.locale.UIStrings;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.waterforpeople.mapping.app.web.CurrentUserServlet;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;

public class EnvServlet
extends HttpServlet {
    private static final long serialVersionUID = 7830536065252808839L;
    private static final Logger log = Logger.getLogger(EnvServlet.class.getName());
    public static final String SHOW_MAPS_PROPERTY_KEY = "showMapsTab";
    public static final String CADDISFLY_TESTS_FILE_URL_KEY = "caddisflyTestsFileUrl";
    private static final ArrayList<String> properties = new ArrayList();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
        try {
            engine.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not initialize velocity", e);
        }
        Template t = null;
        try {
            t = engine.getTemplate("Env.vm");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not get the template `CurrentUser`", e);
            return;
        }
        VelocityContext context = new VelocityContext();
        HashMap<String, String> props = PropertyUtil.getPropertiesMap(properties);
        if (props.get("showMonitoringFeature") == null) {
            props.put("showMonitoringFeature", "false");
        }
        if (props.get("showAltAuthButton") == null) {
            props.put("showAltAuthButton", "false");
        }
        if (props.get("mandatoryQuestionID") == null) {
            props.put("mandatoryQuestionID", "false");
        }
        if (props.get("showExternalSourcesFeature") == null) {
            props.put("showExternalSourcesFeature", "false");
        }
        if (props.get("enableDataApproval") == null) {
            props.put("enableDataApproval", "false");
        }
        if (props.get("googleMapsRegionBias") == null) {
            props.put("googleMapsRegionBias", "");
        }
        if (props.get("extraMapboxTileLayerMapId") == null) {
            props.put("extraMapboxTileLayerMapId", "");
        }
        if (props.get("extraMapboxTileLayerAccessToken") == null) {
            props.put("extraMapboxTileLayerAccessToken", "");
        }
        if (props.get("extraMapboxTileLayerLabel") == null) {
            props.put("extraMapboxTileLayerLabel", "");
        }
        props.put("appId", SystemProperty.applicationId.get());
        if (!"false".equalsIgnoreCase((String)props.get(SHOW_MAPS_PROPERTY_KEY))) {
            props.put(SHOW_MAPS_PROPERTY_KEY, "true");
        }
        if (props.get(CADDISFLY_TESTS_FILE_URL_KEY) == null || ((String)props.get(CADDISFLY_TESTS_FILE_URL_KEY)).isEmpty()) {
            props.put(CADDISFLY_TESTS_FILE_URL_KEY, "https://s3-eu-west-1.amazonaws.com/akvoflow-public/caddisfly-tests-v2.json");
        }
        this.addLocale(props);
        InputStream uiStringsFileStream = ((Object)((Object)this)).getClass().getResourceAsStream("/locale/ui-strings.properties");
        InputStream localeStringsFileStream = null;
        if (props.get("locale") != null && !"en".equalsIgnoreCase((String)props.get("locale"))) {
            localeStringsFileStream = ((Object)((Object)this)).getClass().getResourceAsStream("/locale/" + (String)props.get("locale") + ".properties");
        }
        context.put("localeStrings", (Object)UIStrings.getStrings(uiStringsFileStream, localeStringsFileStream));
        context.put("env", props);
        ArrayList roles = new ArrayList();
        for (AppRole r : AppRole.values()) {
            if (r.getLevel() < 10) continue;
            HashMap<String, String> role = new HashMap<String, String>();
            role.put("value", String.valueOf(r.getLevel()));
            role.put("label", "_" + r.toString());
            roles.add(role);
        }
        context.put("roles", roles);
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        resp.setContentType("application/javascript;charset=UTF-8");
        PrintWriter pw = resp.getWriter();
        pw.println(writer.toString());
        pw.close();
    }

    private void addLocale(Map<String, String> props) {
        User currentUser = CurrentUserServlet.getCurrentUser();
        if (currentUser != null) {
            String locale = currentUser.getLanguage();
            if (locale != null) {
                props.put("locale", locale);
            } else {
                props.put("locale", "en");
            }
        }
    }

    static {
        properties.add("photo_url_root");
        properties.add("imageroot");
        properties.add("flowServices");
        properties.add("showAltAuthButton");
        properties.add("surveyuploadurl");
        properties.add("showMonitoringFeature");
        properties.add("mandatoryQuestionID");
        properties.add("showExternalSourcesFeature");
        properties.add("appId");
        properties.add("mapsProvider");
        properties.add(SHOW_MAPS_PROPERTY_KEY);
        properties.add("googleMapsRegionBias");
        properties.add("hereMapsAppId");
        properties.add("hereMapsAppCode");
        properties.add("enableDataApproval");
        properties.add("extraMapboxTileLayerMapId");
        properties.add("extraMapboxTileLayerAccessToken");
        properties.add("extraMapboxTileLayerLabel");
        properties.add(CADDISFLY_TESTS_FILE_URL_KEY);
    }
}

