/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheManager;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static final Logger log = Logger.getLogger(VelocityUtil.class.getName());
    private static Cache templateCache;
    public static final String CACHE_KEY_PREFIX = "VELOCITY_TEMPLATE/";

    public static String mergeContext(VelocityContext context, String templateName) throws Exception {
        return VelocityUtil.mergeContext(context, templateName, null);
    }

    public static String mergeContext(VelocityContext context, String templateName, TemplateCacheBackingStore backingStore) throws Exception {
        String templateText = (String)templateCache.get((Object)(CACHE_KEY_PREFIX + templateName));
        StringWriter writer = new StringWriter();
        if (templateText == null && backingStore != null && (templateText = backingStore.getByKey(templateName)) != null) {
            templateCache.put((Object)(CACHE_KEY_PREFIX + templateName), (Object)templateText);
        }
        if (templateText == null) {
            Template t = Velocity.getTemplate((String)templateName);
            t.merge((Context)context, (Writer)writer);
        } else {
            Velocity.evaluate((Context)context, (Writer)writer, (String)templateName, (String)templateText);
        }
        return writer.toString();
    }

    static {
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
        try {
            Velocity.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not initialize velocity", e);
        }
        try {
            templateCache = CacheManager.getInstance().getCacheFactory().createCache(Collections.EMPTY_MAP);
        }
        catch (CacheException e) {
            log.log(Level.SEVERE, "Could not initialize cache", e);
        }
    }

    public static interface TemplateCacheBackingStore {
        public String getByKey(String var1);
    }
}

