/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.ApprovalGroupDAO;
import com.gallatinsystems.survey.domain.ApprovalGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.dto.ApprovalGroupDTO;
import org.waterforpeople.mapping.app.web.rest.dto.ApprovalGroupPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/approval_groups"})
public class ApprovalGroupRestService {
    private ApprovalGroupDAO approvalGroupDao = new ApprovalGroupDAO();

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> createApprovalGroup(@RequestBody ApprovalGroupPayload approvalGroupPayload) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto status = new RestStatusDto();
        ApprovalGroup group = approvalGroupPayload.getApproval_group().getApprovalGroup();
        if (group.getName() == null || group.getName().trim().isEmpty()) {
            return null;
        }
        response.put("approval_group", new ApprovalGroupDTO(this.approvalGroupDao.save(group)));
        response.put("meta", status);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{approvalGroupId}"})
    @ResponseBody
    public Map<String, Object> updateApprovalGroup(@RequestBody ApprovalGroupPayload approvalGroupPayload, @PathVariable Long approvalGroupId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto status = new RestStatusDto();
        ApprovalGroup updatedGroup = approvalGroupPayload.getApproval_group().getApprovalGroup();
        if (updatedGroup.getName() == null || updatedGroup.getName().trim().isEmpty()) {
            return null;
        }
        ApprovalGroup storedGroup = (ApprovalGroup)this.approvalGroupDao.getByKey(approvalGroupId);
        if (storedGroup != null) {
            updatedGroup.setKey(storedGroup.getKey());
            response.put("approval_group", new ApprovalGroupDTO(this.approvalGroupDao.save(updatedGroup)));
        }
        response.put("meta", status);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{approvalGroupId}"})
    @ResponseBody
    public void deleteApprovalGroup(@PathVariable Long approvalGroupId) {
        ApprovalGroup approvalGroup = (ApprovalGroup)this.approvalGroupDao.getByKey(approvalGroupId);
        if (approvalGroup != null) {
            this.approvalGroupDao.delete(approvalGroup);
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Map<String, List<ApprovalGroupDTO>> listApprovalGroups() {
        HashMap<String, List<ApprovalGroupDTO>> response = new HashMap<String, List<ApprovalGroupDTO>>();
        ArrayList<ApprovalGroupDTO> approvalGroupsResponseList = new ArrayList<ApprovalGroupDTO>();
        for (ApprovalGroup group : this.approvalGroupDao.list("all")) {
            approvalGroupsResponseList.add(new ApprovalGroupDTO(group));
        }
        response.put("approval_groups", approvalGroupsResponseList);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{approvalGroupId}"})
    @ResponseBody
    public Map<String, ApprovalGroupDTO> findApprovalGroup(@PathVariable Long approvalGroupId) {
        HashMap<String, ApprovalGroupDTO> response = new HashMap<String, ApprovalGroupDTO>();
        ApprovalGroup approvalGroup = (ApprovalGroup)this.approvalGroupDao.getByKey(approvalGroupId);
        if (approvalGroup != null) {
            response.put("approval_group", new ApprovalGroupDTO(approvalGroup));
        }
        return response;
    }
}

