/*
 * Decompiled with CFR 0.152.
 */
package test.java.org.waterforpeople.mapping.dataexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.waterforpeople.mapping.dataexport.RawDataSpreadsheetImporter;

class RawDataSpreadsheetImporterTests {
    RawDataSpreadsheetImporterTests() {
    }

    private void createSheet(Workbook wb, String name, String topleft, boolean app, boolean rep, int questionColumns) {
        Sheet sheet = wb.createSheet(name);
        Row row0 = sheet.createRow(0);
        row0.createCell(0).setCellValue(topleft);
        Row row1 = sheet.createRow(1);
        int i = 0;
        row1.createCell(i++).setCellValue("Identifier");
        if (app) {
            row1.createCell(i++).setCellValue("Data approval status");
        }
        row1.createCell(i++).setCellValue("Display Name");
        if (rep) {
            row1.createCell(i++).setCellValue("Repeat no");
        }
        row1.createCell(i++).setCellValue("Device identifier");
        row1.createCell(i++).setCellValue("Instance");
        row1.createCell(i++).setCellValue("Submission Date");
        row1.createCell(i++).setCellValue("Submitter");
        row1.createCell(i++).setCellValue("Duration");
        row1.createCell(i++).setCellValue("Form version");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, i - 1));
        for (int j = 0; j < questionColumns; ++j) {
            row1.createCell(i + j).setCellValue(j + "|Question" + j);
        }
    }

    private File createValidTestSpreadsheet(String fileName) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(10);
        this.createSheet((Workbook)wb, "Raw Data", "Metadata", false, false, 0);
        this.createSheet((Workbook)wb, "Group 2", "Metadata", false, true, 1);
        this.createSheet((Workbook)wb, "Foobar", "Not metadata", false, true, 0);
        FileOutputStream fileOut = new FileOutputStream(fileName);
        wb.setActiveSheet(0);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        return new File(fileName);
    }

    private File createNoQuestionsSpreadsheet(String fileName) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(10);
        this.createSheet((Workbook)wb, "Raw Data", "Metadata", false, false, 0);
        this.createSheet((Workbook)wb, "Group 2", "Metadata", false, true, 0);
        FileOutputStream fileOut = new FileOutputStream(fileName);
        wb.setActiveSheet(0);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        return new File(fileName);
    }

    @Test
    void testValidSheets() throws IOException {
        RawDataSpreadsheetImporter dimp = new RawDataSpreadsheetImporter();
        File file1 = this.createValidTestSpreadsheet("/tmp/valid1.xlsx");
        Map<Integer, String> errors = dimp.validate(file1);
        for (Integer i : errors.keySet()) {
            System.out.printf("Unexpected error, row %d: %s", i, errors.get(i));
        }
        Assertions.assertEquals((int)0, (int)errors.size());
    }

    @Test
    void testNoQuestionColumns() throws IOException {
        RawDataSpreadsheetImporter dimp = new RawDataSpreadsheetImporter();
        File file = this.createNoQuestionsSpreadsheet("/tmp/invalid1.xlsx");
        Map<Integer, String> errors = dimp.validate(file);
        Assertions.assertEquals((int)1, (int)errors.size());
        String err1 = errors.get(-11);
        Assertions.assertNotEquals((Object)err1, null);
    }
}

