/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.api.server.spi.config.Nullable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.app.web.dto.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleRequest;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleResponse;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class SurveyedLocaleServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 8748650927754433019L;
    private SurveyedLocaleDao surveyedLocaleDao;
    private static final Integer SL_PAGE_SIZE = 30;

    public SurveyedLocaleServlet() {
        this.setMode("JSON");
        this.surveyedLocaleDao = new SurveyedLocaleDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyedLocaleRequest restRequest = new SurveyedLocaleRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        SurveyedLocaleRequest slReq = (SurveyedLocaleRequest)req;
        if (slReq.getSurveyGroupId() != null) {
            DeviceSurveyJobQueueDAO dsjqDAO = new DeviceSurveyJobQueueDAO();
            SurveyDAO surveyDao = new SurveyDAO();
            List<DeviceSurveyJobQueue> deviceSurveyJobQueues = dsjqDAO.get(slReq.getPhoneNumber(), slReq.getImei(), slReq.getAndroidId());
            for (DeviceSurveyJobQueue dsjq : deviceSurveyJobQueues) {
                Survey s = surveyDao.getById(dsjq.getSurveyID());
                if (s == null || s.getSurveyGroupId().longValue() != slReq.getSurveyGroupId().longValue()) continue;
                List<SurveyedLocale> slList = this.surveyedLocaleDao.listLocalesBySurveyGroupAndDate(slReq.getSurveyGroupId(), slReq.getLastUpdateTime(), SL_PAGE_SIZE);
                return this.convertToResponse(slList, slReq.getSurveyGroupId());
            }
        }
        RestResponse res = new RestResponse();
        res.setCode(String.valueOf(403));
        res.setMessage("Invalid assignment");
        return res;
    }

    private SurveyedLocaleResponse convertToResponse(List<SurveyedLocale> slList, Long surveyGroupId) {
        SurveyedLocaleResponse resp = new SurveyedLocaleResponse();
        if (slList == null) {
            resp.setCode(String.valueOf(500));
            resp.setMessage("Internal Server Error");
            return resp;
        }
        resp.setCode(String.valueOf(200));
        resp.setResultCount(slList.size());
        List<SurveyedLocaleDto> dtoList = this.getSurveyedLocaleDtosList(slList, surveyGroupId);
        resp.setSurveyedLocaleData(dtoList);
        return resp;
    }

    private List<SurveyedLocaleDto> getSurveyedLocaleDtosList(List<SurveyedLocale> slList, Long surveyGroupId) {
        ArrayList<SurveyedLocaleDto> dtoList = new ArrayList<SurveyedLocaleDto>();
        HashMap<Long, String> questionTypeMap = new HashMap<Long, String>();
        QuestionDao questionDao = new QuestionDao();
        List<Long> surveyedLocalesIds = this.getSurveyedLocalesIds(slList);
        Map<Long, List<SurveyInstance>> surveyInstancesMap = this.getSurveyInstances(surveyedLocalesIds);
        Map<Long, List<QuestionAnswerStore>> questionAnswerStore = this.getQuestionAnswerStoreMap(surveyInstancesMap);
        for (SurveyedLocale surveyedLocale : slList) {
            long surveyedLocaleId = surveyedLocale.getKey().getId();
            SurveyedLocaleDto dto = this.createSurveyedLocaleDto(surveyGroupId, questionDao, questionTypeMap, surveyedLocale, questionAnswerStore, surveyInstancesMap.get(surveyedLocaleId));
            dtoList.add(dto);
        }
        return dtoList;
    }

    private SurveyedLocaleDto createSurveyedLocaleDto(Long surveyGroupId, QuestionDao questionDao, HashMap<Long, String> questionTypeMap, SurveyedLocale surveyedLocale, Map<Long, List<QuestionAnswerStore>> questionAnswerStoreMap, @Nullable List<SurveyInstance> surveyInstances) {
        SurveyedLocaleDto dto = new SurveyedLocaleDto();
        dto.setId(surveyedLocale.getIdentifier());
        dto.setSurveyGroupId(surveyGroupId);
        dto.setDisplayName(surveyedLocale.getDisplayName());
        dto.setLat(surveyedLocale.getLatitude());
        dto.setLon(surveyedLocale.getLongitude());
        dto.setLastUpdateDateTime(surveyedLocale.getLastUpdateDateTime());
        if (surveyInstances != null) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                Long surveyInstanceId = surveyInstance.getObjectId();
                List<QuestionAnswerStore> answerStores = questionAnswerStoreMap.get(surveyInstanceId);
                SurveyInstanceDto siDto = this.createSurveyInstanceDto(questionDao, questionTypeMap, answerStores, surveyInstance);
                dto.getSurveyInstances().add(siDto);
            }
        }
        return dto;
    }

    private Map<Long, List<QuestionAnswerStore>> getQuestionAnswerStoreMap(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        QuestionAnswerStoreDao questionAnswerStoreDao = new QuestionAnswerStoreDao();
        List<Long> surveyInstancesIds = this.getSurveyInstancesIds(surveyInstanceMap);
        List surveyalValueList = questionAnswerStoreDao.fetchItemsByIdBatches(surveyInstancesIds, "surveyInstanceId");
        HashMap<Long, List<QuestionAnswerStore>> questionAnswerStoreMap = new HashMap<Long, List<QuestionAnswerStore>>();
        if (surveyalValueList != null && surveyalValueList.size() > 0) {
            for (QuestionAnswerStore questionAnswerStore : surveyalValueList) {
                Long surveyInstanceId = questionAnswerStore.getSurveyInstanceId();
                if (questionAnswerStoreMap.containsKey(surveyInstanceId)) {
                    ((List)questionAnswerStoreMap.get(surveyInstanceId)).add(questionAnswerStore);
                    continue;
                }
                ArrayList<QuestionAnswerStore> questionAnswerStores = new ArrayList<QuestionAnswerStore>();
                questionAnswerStores.add(questionAnswerStore);
                questionAnswerStoreMap.put(surveyInstanceId, questionAnswerStores);
            }
        }
        return questionAnswerStoreMap;
    }

    private List<Long> getSurveyInstancesIds(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        ArrayList<Long> surveyInstancesIds = new ArrayList<Long>();
        Collection<List<SurveyInstance>> values = surveyInstanceMap.values();
        for (List<SurveyInstance> surveyInstances : values) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                surveyInstancesIds.add(surveyInstance.getObjectId());
            }
        }
        return surveyInstancesIds;
    }

    private Map<Long, List<SurveyInstance>> getSurveyInstances(List<Long> surveyedLocalesIds) {
        SurveyInstanceDAO surveyInstanceDAO = new SurveyInstanceDAO();
        List values = surveyInstanceDAO.fetchItemsByIdBatches(surveyedLocalesIds, "surveyedLocaleId");
        HashMap<Long, List<SurveyInstance>> surveyInstancesMap = new HashMap<Long, List<SurveyInstance>>();
        for (SurveyInstance surveyInstance : values) {
            Long surveyedLocaleId = surveyInstance.getSurveyedLocaleId();
            if (surveyInstancesMap.containsKey(surveyedLocaleId)) {
                ((List)surveyInstancesMap.get(surveyedLocaleId)).add(surveyInstance);
                continue;
            }
            ArrayList<SurveyInstance> instances = new ArrayList<SurveyInstance>();
            instances.add(surveyInstance);
            surveyInstancesMap.put(surveyedLocaleId, instances);
        }
        return surveyInstancesMap;
    }

    private List<Long> getSurveyedLocalesIds(List<SurveyedLocale> slList) {
        if (slList == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> surveyedLocaleIds = new ArrayList<Long>(slList.size());
        for (SurveyedLocale surveyedLocale : slList) {
            surveyedLocaleIds.add(surveyedLocale.getKey().getId());
        }
        return surveyedLocaleIds;
    }

    private SurveyInstanceDto createSurveyInstanceDto(QuestionDao qDao, HashMap<Long, String> questionTypeMap, @Nullable List<QuestionAnswerStore> questionAnswerStores, @Nullable SurveyInstance surveyInstance) {
        SurveyInstanceDto surveyInstanceDto = new SurveyInstanceDto();
        if (surveyInstance != null) {
            surveyInstanceDto.setUuid(surveyInstance.getUuid());
            surveyInstanceDto.setSubmitter(surveyInstance.getSubmitterName());
            surveyInstanceDto.setSurveyId(surveyInstance.getSurveyId());
            surveyInstanceDto.setCollectionDate(surveyInstance.getCollectionDate().getTime());
        }
        if (questionAnswerStores != null) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerStores) {
                Long questionId = questionAnswerStore.getQuestionIDLong();
                if (questionId == null) continue;
                String type = this.getQuestionType(qDao, questionTypeMap, questionAnswerStore);
                String value = this.getAnswerValue(questionAnswerStore, type);
                surveyInstanceDto.addProperty(questionId, value, type);
            }
        }
        return surveyInstanceDto;
    }

    private String getAnswerValue(QuestionAnswerStore questionAnswerStore, String type) {
        String answerValue = questionAnswerStore.getValue();
        String value = answerValue != null ? answerValue : "";
        switch (type) {
            case "OPTION": 
            case "OTHER": {
                if (!value.startsWith("[")) break;
                value = DataUtils.jsonResponsesToPipeSeparated(value);
                break;
            }
            case "IMAGE": 
            case "VIDEO": {
                value = MediaResponse.format(value, 0);
                break;
            }
        }
        return value;
    }

    private String getQuestionType(QuestionDao questionDao, HashMap<Long, String> questionTypeMap, QuestionAnswerStore questionAnswerStore) {
        String type = questionAnswerStore.getType();
        if (type == null || "".equals(type)) {
            type = "VALUE";
        } else if ("PHOTO".equals(type)) {
            type = "IMAGE";
        } else if ("OPTION".equals(type)) {
            Long questionId = questionAnswerStore.getQuestionIDLong();
            if (questionTypeMap.containsKey(questionId)) {
                type = questionTypeMap.get(questionId);
            } else {
                Question question = questionDao.getByKey(questionId);
                if (question != null) {
                    if (question.getAllowOtherFlag().booleanValue()) {
                        type = "OTHER";
                    }
                    questionTypeMap.put(questionId, type);
                }
            }
        }
        return type;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
            writer.writeValue((OutputStream)this.getResponse().getOutputStream(), resp);
            this.getResponse().getWriter().println();
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

