/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest.security;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import java.util.Date;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.waterforpeople.mapping.app.web.rest.security.ApiUserAuthentication;
import org.waterforpeople.mapping.app.web.rest.security.user.ApiUser;

public class ApiAuthenticationProvider
implements AuthenticationProvider {
    private UserDao userDao = new UserDao();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String payload;
        String serverSignature;
        long timeDelta;
        Map details = (Map)authentication.getDetails();
        String[] credentials = this.parseCredentials((String)details.get("Authorization"));
        String accessKey = credentials[0];
        String clientSignature = credentials[1];
        ApiUser apiUser = this.findUser(accessKey);
        if (apiUser == null) {
            throw new BadCredentialsException("Authorization Required");
        }
        Date date = this.parseDate((String)details.get("Date"));
        long clientTime = date.getTime();
        long serverTime = new Date().getTime();
        if (serverTime - (timeDelta = 600000L) < clientTime && clientTime < serverTime + timeDelta && clientSignature.equals(serverSignature = MD5Util.generateHMAC(payload = this.buildPayload((String)details.get("HTTP-Verb"), date, (String)details.get("Resource")), apiUser.getSecret()))) {
            return new ApiUserAuthentication(apiUser);
        }
        throw new BadCredentialsException("Authorization Required");
    }

    private ApiUser findUser(String accessKey) {
        User user = this.userDao.findByAccessKey(accessKey);
        if (user != null) {
            return new ApiUser(user.getUserName(), user.getAccessKey(), user.getSecret(), user.getKey().getId());
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    private String[] parseCredentials(String credentialsString) {
        if (credentialsString == null) {
            throw new BadCredentialsException("Authorization required");
        }
        String[] credentials = credentialsString.split(":");
        if (credentials.length != 2) {
            throw new BadCredentialsException("Authorization required");
        }
        credentials[0] = credentials[0].trim();
        credentials[1] = credentials[1].trim();
        return credentials;
    }

    private Date parseDate(String dateString) {
        try {
            return new Date(Long.parseLong(dateString) * 1000L);
        }
        catch (NumberFormatException e) {
            throw new BadCredentialsException("Authorization Required");
        }
    }

    private String buildPayload(String httpVerb, Date date, String resource) {
        return httpVerb + "\n" + String.valueOf(date.getTime() / 1000L) + "\n" + resource;
    }
}

