/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.DataImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class SurveySpreadsheetImporter
implements DataImporter {
    private static final Logger log = Logger.getLogger(SurveySpreadsheetImporter.class);
    private static final String SERVLET_URL = "/surveyrestapi";
    private static final String BEFORE_QUESTION_ID_PARAM = "beforeQuestionId";
    private static final String WHOLE_SURVEY_PARAM = "isWholeSurvey";
    private static final String KEY_PARAM = "k";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImport(File file, String serverBase, Map<String, String> criteria) {
        FileInputStream inp = null;
        HSSFSheet sheet1 = null;
        Integer startRow = 1;
        Long beforeQuestionId = null;
        boolean isWholeSurvey = true;
        if (criteria != null) {
            if (criteria.get(BEFORE_QUESTION_ID_PARAM) != null) {
                beforeQuestionId = new Long(criteria.get(BEFORE_QUESTION_ID_PARAM));
            }
            if (criteria.get(WHOLE_SURVEY_PARAM) != null && "false".equalsIgnoreCase(criteria.get(WHOLE_SURVEY_PARAM))) {
                isWholeSurvey = false;
            }
        }
        try {
            String apiKey;
            inp = new FileInputStream(file);
            HSSFWorkbook wb = new HSSFWorkbook(new POIFSFileSystem((InputStream)inp));
            sheet1 = wb.getSheetAt(0);
            String string = apiKey = criteria != null ? criteria.get("apiKey") : null;
            if (!isWholeSurvey) {
                int questionCount = sheet1.getLastRowNum();
                QuestionDto startingQuestion = BulkDataServiceClient.loadQuestionDetails(serverBase, beforeQuestionId, apiKey);
                startRow = startingQuestion.getOrder();
                List<QuestionDto> questionsInGroup = BulkDataServiceClient.fetchQuestions(serverBase, startingQuestion.getQuestionGroupId(), apiKey);
                if (questionsInGroup != null) {
                    for (QuestionDto q : questionsInGroup) {
                        if (q.getOrder() < startRow) continue;
                        StringBuilder reorderBuffer = new StringBuilder();
                        reorderBuffer.append("?").append("action").append("=").append("updateQuestionOrder").append("&").append("questionID").append("=").append(q.getKeyId()).append("&").append("questionOrder").append("=").append(q.getOrder() + questionCount);
                        String result = BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, reorderBuffer.toString(), true, criteria.get(KEY_PARAM));
                        log.debug((Object)result);
                    }
                }
            }
            for (Row row : sheet1) {
                if (row.getRowNum() < 1) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("?").append("action").append("=").append("saveQuestion").append("&");
                for (Cell cell : row) {
                    switch (cell.getColumnIndex()) {
                        case 0: {
                            sb.append("surveyGroupName").append("=").append(URLEncoder.encode(this.parseCellAsString(cell).trim(), "UTF-8")).append("&");
                            break;
                        }
                        case 1: {
                            sb.append("surveyName").append("=").append(URLEncoder.encode(this.parseCellAsString(cell).trim(), "UTF-8")).append("&");
                            break;
                        }
                        case 2: {
                            sb.append("questionGroupOrder").append("=").append(new Double(cell.getNumericCellValue()).intValue()).append("&");
                            break;
                        }
                        case 3: {
                            sb.append("questionGroupName").append("=").append(URLEncoder.encode(this.parseCellAsString(cell).trim(), "UTF-8")).append("&");
                            break;
                        }
                        case 4: {
                            int order = new Double(cell.getNumericCellValue()).intValue();
                            if (!isWholeSurvey) {
                                order += startRow - 1;
                            }
                            sb.append("questionOrder").append("=").append(order).append("&");
                            break;
                        }
                        case 5: {
                            sb.append("questionText").append("=").append(URLEncoder.encode(this.parseCellAsString(cell).trim(), "UTF-8")).append("&");
                            break;
                        }
                        case 6: {
                            sb.append("questionType").append("=").append(URLEncoder.encode(this.parseCellAsString(cell).trim(), "UTF-8")).append("&");
                            break;
                        }
                        case 7: {
                            sb.append("options").append("=").append(URLEncoder.encode(this.parseCellAsString(cell).trim(), "UTF-8")).append("&");
                            break;
                        }
                        case 8: {
                            String valString = this.parseCellAsString(cell);
                            if (valString == null || valString.trim().length() <= 0) break;
                            String[] parts = valString.split("\\|");
                            int depOrder = new Integer(parts[0].trim());
                            if (!isWholeSurvey) {
                                depOrder += startRow - 1;
                            }
                            sb.append("dependQuestion").append("=").append(URLEncoder.encode(depOrder + "|" + parts[1], "UTF-8")).append("&");
                            break;
                        }
                        case 9: {
                            sb.append("allowOther").append("=").append(this.parseCellAsString(cell)).append("&");
                            break;
                        }
                        case 10: {
                            sb.append("allowMultiple").append("=").append(this.parseCellAsString(cell)).append("&");
                            break;
                        }
                        case 11: {
                            sb.append("mandatory").append("=").append(this.parseCellAsString(cell)).append("&");
                            break;
                        }
                        case 12: {
                            sb.append("scoring").append("=").append(this.parseCellAsString(cell));
                            break;
                        }
                        case 13: {
                            String minVal = this.parseCellAsString(cell);
                            if (minVal == null || minVal.trim().length() <= 0) break;
                            sb.append("&").append("minVal").append("=").append(minVal);
                            break;
                        }
                        case 14: {
                            String maxVal = this.parseCellAsString(cell);
                            if (maxVal == null || maxVal.trim().length() <= 0) break;
                            sb.append("&").append("maxVal").append("=").append(maxVal);
                            break;
                        }
                        case 15: {
                            String signVal = this.parseCellAsString(cell);
                            if (signVal == null || signVal.trim().length() <= 0) break;
                            sb.append("&").append("allowSign").append("=").append(signVal);
                            break;
                        }
                        case 16: {
                            String decimalVal = this.parseCellAsString(cell);
                            if (decimalVal == null || decimalVal.trim().length() <= 0) break;
                            sb.append("&").append("allowDecimal").append("=").append(decimalVal);
                            break;
                        }
                        case 17: {
                            String isNameVal = this.parseCellAsString(cell);
                            if (isNameVal == null || isNameVal.trim().length() <= 0) break;
                            sb.append("&").append("isName").append("=").append(isNameVal);
                            break;
                        }
                        case 18: {
                            String metricName = this.parseCellAsString(cell);
                            if (metricName == null || metricName.trim().length() <= 0) break;
                            sb.append("&").append("metricName").append("=").append(metricName);
                            break;
                        }
                        case 19: {
                            String metricGroup = this.parseCellAsString(cell);
                            if (metricGroup == null || metricGroup.trim().length() <= 0) break;
                            sb.append("&").append("metricGroup").append("=").append(metricGroup);
                        }
                    }
                }
                try {
                    String result = BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, sb.toString(), true, criteria.get(KEY_PARAM));
                    log.debug((Object)result);
                }
                catch (Throwable t) {
                    log.error((Object)("Error: " + t.getMessage()), t);
                    log.info((Object)"Trying again");
                    try {
                        BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, sb.toString(), true, criteria.get(KEY_PARAM));
                    }
                    catch (Exception e) {
                        log.error((Object)("Error:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String parseCellAsString(Cell cell) {
        String val = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 4: {
                    val = cell.getBooleanCellValue() + "";
                    break;
                }
                case 0: {
                    val = cell.getNumericCellValue() + "";
                    break;
                }
                default: {
                    val = cell.getStringCellValue();
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Map<Integer, String> validate(File file) {
        inp = null;
        sheet1 = null;
        errorMap = new TreeMap<Integer, String>();
        try {
            inp = new FileInputStream(file);
            wb = new HSSFWorkbook(new POIFSFileSystem((InputStream)inp));
            sheet1 = wb.getSheetAt(0);
            for (Row row : sheet1) {
                rowError = new StringBuffer();
                if (row.getRowNum() < 1) continue;
                type = null;
lbl12:
                // 31 sources

                block35: for (Cell cell : row) {
                    try {
                        switch (cell.getColumnIndex()) {
                            case 0: {
                                if (cell.getStringCellValue().trim().length() != 0) ** break;
                                rowError.append("Survey Group Name is missing\n");
                                ** break;
                            }
                            case 1: {
                                if (cell.getStringCellValue().trim().length() != 0) ** break;
                                rowError.append("Survey Name is missing\n");
                                ** break;
                            }
                            case 2: {
                                try {
                                    if (!(cell.getNumericCellValue() < 0.0)) continue block35;
                                    rowError.append("Question Group Order must be a positive integer\n");
                                }
                                catch (Exception e) {
                                    rowError.append("Question group order must be a number\n");
                                }
                                continue block35;
                            }
                            case 3: {
                                if (cell.getStringCellValue().trim().length() != 0) ** break;
                                rowError.append("Question Group Name is missing\n");
                                ** break;
                            }
                            case 4: {
                                try {
                                    if (!(cell.getNumericCellValue() < 0.0)) continue block35;
                                    rowError.append("Question Id Order must be a positive integer\n");
                                }
                                catch (Exception e) {
                                    rowError.append("Question Id order must be a number\n");
                                }
                                continue block35;
                            }
                            case 5: {
                                if (cell.getStringCellValue().trim().length() != 0) ** break;
                                rowError.append("Question Text is missing\n");
                                ** break;
                            }
                            case 6: {
                                type = cell.getStringCellValue().trim();
                                if (type.length() == 0) {
                                    rowError.append("Question Type is missing\n");
                                    ** break;
                                }
                                if ((type.equals(QuestionDto.QuestionType.FREE_TEXT.toString()) || type.equals(QuestionDto.QuestionType.PHOTO.toString()) || type.equals(QuestionDto.QuestionType.VIDEO.toString()) || type.equals(QuestionDto.QuestionType.GEO.toString()) || type.equals(QuestionDto.QuestionType.SCAN.toString()) || type.equals(QuestionDto.QuestionType.TRACK.toString()) || type.equals(QuestionDto.QuestionType.NUMBER.toString()) || type.equals(QuestionDto.QuestionType.OPTION.toString())) && !type.equals(QuestionDto.QuestionType.STRENGTH.toString())) continue block35;
                                rowError.append("Invalid question type. Must be either: FREE_TEXT, PHOTO, VIDEO, GEO, NUMBER, OPTION, SCAN, TRACK, NAME, STRENGTH\n");
                                ** break;
                            }
                            case 7: {
                                if (!QuestionDto.QuestionType.OPTION.toString().equals(type) && !QuestionDto.QuestionType.STRENGTH.toString().equals(type) || cell.getStringCellValue().trim().length() != 0) continue block35;
                                rowError.append("Options are missing\n");
                                ** break;
                            }
                            case 8: {
                                ** break;
                            }
                            case 9: {
                                if (this.validateBooleanField(cell)) ** break;
                                rowError.append("Allow Other must be either TRUE or FALSE\n");
                                ** break;
                            }
                            case 10: {
                                if (this.validateBooleanField(cell)) ** break;
                                rowError.append("Allow Multiple must be either TRUE or FALSE\n");
                                ** break;
                            }
                            case 11: {
                                if (this.validateBooleanField(cell)) ** break;
                                rowError.append("Manditory must be either TRUE or FALSE\n");
                                continue block35;
                            }
                            ** default:
lbl88:
                            // 1 sources

                            continue block35;
                        }
                    }
                    catch (Exception e) {
                        rowError.append(e.toString());
                    }
                    finally {
                        if (rowError.toString().trim().length() <= 0) continue;
                        errorMap.put(row.getRowNum() + 1, rowError.toString().trim());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return errorMap;
    }

    private boolean validateBooleanField(Cell cell) {
        try {
            cell.getBooleanCellValue();
        }
        catch (Exception e) {
            try {
                if (cell.getStringCellValue().trim().length() > 0 && !"TRUE".equalsIgnoreCase(cell.getStringCellValue().trim()) && !"FALSE".equalsIgnoreCase(cell.getStringCellValue().trim())) {
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }
}

