/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.waterforpeople.mapping.domain.CaddisflyResource;

public class CaddisflyResourceDao {
    public static String DEFAULT_CADDISFLY_TESTS_FILE_URL = "https://akvoflow-public.s3.amazonaws.com/caddisfly-tests.json";
    private static final Logger log = Logger.getLogger(CascadeResourceDao.class.getName());

    public List<CaddisflyResource> listResources(String caddisflyTestsUrl) {
        Map<String, List<CaddisflyResource>> testsMap = null;
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        try {
            URL caddisflyFileUrl = new URL(caddisflyTestsUrl);
            testsMap = jsonReader.readObject(caddisflyFileUrl, new TypeReference<Map<String, List<CaddisflyResource>>>(){});
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing Caddisfly resource: " + e.getMessage(), e);
        }
        if (testsMap != null && testsMap.get("tests") != null) {
            return testsMap.get("tests");
        }
        return Collections.emptyList();
    }

    public List<CaddisflyResource> listResources() {
        return this.listResources(DEFAULT_CADDISFLY_TESTS_FILE_URL);
    }
}

