/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.dto.DeleteTaskRequest;

public class DeleteObjectTaskServlet
extends AbstractRestApiServlet {
    private static final String DELETE_OBJECT_TASK_URL = "/app_worker/deleteobjecttask";
    private static final String DELETE_QUEUE_NAME = "deletequeue";
    private static final long serialVersionUID = -7978453807761868626L;

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DeleteTaskRequest restRequest = new DeleteTaskRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DeleteTaskRequest dtReq = (DeleteTaskRequest)this.convertRequest();
        if (dtReq.getKey().equals("secret")) {
            this.deleteObject(dtReq.getObjectName(), dtReq.getTaskCount(), dtReq.getApiKey());
        }
        return null;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        if (resp != null) {
            this.getResponse().getWriter().println("ok");
        }
    }

    private void deleteObject(String objectName, String taskCount, String key) {
        String kind = objectName;
        int deleted_count = 0;
        boolean is_finished = false;
        DatastoreService dss = DatastoreServiceFactory.getDatastoreService();
        long start = System.currentTimeMillis();
        block2: while (System.currentTimeMillis() - start < 16384L) {
            Query query = new Query(kind);
            query.setKeysOnly();
            ArrayList<Key> keys = new ArrayList<Key>();
            for (Entity entity : dss.prepare(query).asIterable(FetchOptions.Builder.withLimit((int)128))) {
                keys.add(entity.getKey());
            }
            keys.trimToSize();
            if (keys.size() == 0) {
                is_finished = true;
                break;
            }
            while (System.currentTimeMillis() - start < 16384L) {
                try {
                    dss.delete(keys);
                    deleted_count += keys.size();
                    continue block2;
                }
                catch (Throwable ignore) {
                }
            }
        }
        System.err.println("*** deleted " + deleted_count + " entities from " + kind);
        if (is_finished) {
            System.err.println("*** deletion job for " + kind + " is completed.");
        } else {
            String tcs = taskCount;
            Integer taskcount = tcs == null ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(tcs) + 1);
            Queue deleteQueue = QueueFactory.getQueue((String)DELETE_QUEUE_NAME);
            deleteQueue.add(TaskOptions.Builder.withUrl((String)DELETE_OBJECT_TASK_URL).param("object", kind + "").param("key", key).param("taskCount", taskcount.toString()));
            System.err.println("*** deletion task # " + taskcount + " for " + kind + " is queued.");
        }
    }
}

