/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.CascadeNodeDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.CascadeNode;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyalValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.domain.DataUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.QuestionAnswerStoreDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.DataProcessorRestServlet;
import org.waterforpeople.mapping.app.web.rest.dto.QuestionAnswerStorePayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

@Controller
@RequestMapping(value={"/question_answers"})
public class QuestionAnswerRestService {
    private QuestionAnswerStoreDao questionAnswerStoreDao = new QuestionAnswerStoreDao();
    private QuestionDao questionDao = new QuestionDao();
    private CascadeNodeDao cascadeNodeDao = new CascadeNodeDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<QuestionAnswerStoreDto>> listQABySurveyInstanceId(HttpServletRequest httpRequest, @RequestParam(value="surveyInstanceId", defaultValue="") Long surveyInstanceId) {
        HashMap<String, List<QuestionAnswerStoreDto>> response = new HashMap<String, List<QuestionAnswerStoreDto>>();
        ArrayList<QuestionAnswerStoreDto> results = new ArrayList<QuestionAnswerStoreDto>();
        List<QuestionAnswerStore> questionAnswerStores = null;
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        QuestionDao qDao = new QuestionDao();
        if (surveyInstanceId != null && (questionAnswerStores = siDao.listQuestionAnswerStore(surveyInstanceId, null)) != null && questionAnswerStores.size() > 0) {
            List<Question> qList = qDao.listQuestionsInOrder(questionAnswerStores.get(0).getSurveyId(), null);
            results = new ArrayList();
            int notFoundCount = 0;
            if (qList != null) {
                for (QuestionAnswerStore qas : questionAnswerStores) {
                    QuestionAnswerStoreDto qasDto = new QuestionAnswerStoreDto();
                    DtoMarshaller.copyToDto(qas, qasDto);
                    int idx = -1;
                    for (int i = 0; i < qList.size(); ++i) {
                        if (Long.parseLong(qas.getQuestionID()) != qList.get(i).getKey().getId()) continue;
                        qasDto.setQuestionText(qList.get(i).getText());
                        idx = i;
                        break;
                    }
                    if (idx < 0) {
                        results.add(notFoundCount++, qasDto);
                        continue;
                    }
                    idx += notFoundCount;
                    while (results.size() < idx + 1) {
                        results.add(null);
                    }
                    this.processApiResponse(qasDto, httpRequest);
                    results.add(idx, qasDto);
                }
            }
        }
        while (results.remove(null)) {
        }
        response.put("question_answers", results);
        return response;
    }

    private void processApiResponse(QuestionAnswerStoreDto response, HttpServletRequest httpRequest) {
        if (httpRequest.getRequestURI().startsWith("/api/v1")) {
            this.formatResponseAPIV1(response);
        } else {
            this.formatResponseLatestAPI(response);
        }
    }

    private void formatResponseAPIV1(QuestionAnswerStoreDto response) {
        String value = response.getValue();
        String type = response.getType();
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        switch (type) {
            case "OPTION": 
            case "OTHER": {
                if (!value.startsWith("[")) break;
                response.setValue(DataUtils.jsonResponsesToPipeSeparated(value));
                break;
            }
            case "IMAGE": 
            case "VIDEO": {
                response.setValue(MediaResponse.format(value, 0));
                break;
            }
        }
    }

    private void formatResponseLatestAPI(QuestionAnswerStoreDto response) {
        String value = response.getValue();
        String type = response.getType();
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        switch (type) {
            case "IMAGE": 
            case "VIDEO": {
                value = MediaResponse.format(value, 1);
                response.setValue(value);
                break;
            }
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, QuestionAnswerStoreDto> findQuestionAnswerStore(@PathVariable(value="id") Long id) {
        HashMap<String, QuestionAnswerStoreDto> response = new HashMap<String, QuestionAnswerStoreDto>();
        QuestionAnswerStoreDao qaDao = new QuestionAnswerStoreDao();
        QuestionAnswerStore s = (QuestionAnswerStore)qaDao.getByKey(id);
        QuestionAnswerStoreDto dto = null;
        if (s != null) {
            dto = new QuestionAnswerStoreDto();
            DtoMarshaller.copyToDto(s, dto);
            this.formatResponseLatestAPI(dto);
        }
        response.put("question_answer", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingQuestionAnswerStore(@RequestBody QuestionAnswerStorePayload payLoad) {
        QuestionAnswerStoreDto requestDto = payLoad.getQuestion_answer();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("meta", statusDto);
        QuestionAnswerStoreDto responseDto = new QuestionAnswerStoreDto();
        if (requestDto != null) {
            QuestionAnswerStore qa;
            Long keyId = requestDto.getKeyId();
            Question q = this.questionDao.getByKey(Long.parseLong(requestDto.getQuestionID()));
            if (keyId != null && q != null && (qa = (QuestionAnswerStore)this.questionAnswerStoreDao.getByKey(keyId)) != null) {
                if (Question.Type.OPTION.equals((Object)q.getType())) {
                    SurveyQuestionSummaryDao.incrementCount(qa, -1);
                    String newVal = requestDto.getValue();
                    if (newVal != null && newVal.trim().length() > 0) {
                        SurveyQuestionSummaryDao.incrementCount(this.constructQAS(qa.getQuestionID(), newVal), 1);
                    }
                } else if (Question.Type.CASCADE.equals((Object)q.getType())) {
                    JSONArray cascadeResponse = null;
                    boolean isValidJson = true;
                    boolean isValidResponse = true;
                    try {
                        cascadeResponse = new JSONArray(requestDto.getValue());
                        isValidResponse = this.isValidCascadeResponse(q, cascadeResponse);
                    }
                    catch (JSONException e) {
                        isValidJson = false;
                    }
                    if (!isValidJson || !isValidResponse) {
                        statusDto.setMessage("_invalid_cascade_response");
                        return response;
                    }
                }
                BeanUtils.copyProperties((Object)requestDto, (Object)qa, (String[])new String[]{"createdDateTime", "status", "version", "lastUpdateDateTime", "displayName", "questionGroupList", "questionText"});
                qa = this.questionAnswerStoreDao.save(qa);
                Long surveyInstanceId = qa.getSurveyInstanceId();
                String questionId = qa.getQuestionID();
                SurveyedLocaleDao slDao = new SurveyedLocaleDao();
                List<SurveyalValue> svals = slDao.listSVByQuestionAndSurveyInstance(surveyInstanceId, Long.parseLong(questionId));
                Long surveyedLocaleId = null;
                if (svals != null && svals.size() > 0) {
                    SurveyalValue sval = svals.get(0);
                    sval.setStringValue(qa.getValue());
                    slDao.save(sval);
                    surveyedLocaleId = sval.getSurveyedLocaleId();
                }
                if (q.getLocaleNameFlag().booleanValue() && surveyedLocaleId != null) {
                    DataProcessorRestServlet.scheduleDatapointNameAssembly(null, surveyedLocaleId, true);
                }
                DtoMarshaller.copyToDto(qa, responseDto);
                responseDto.setQuestionText(requestDto.getQuestionText());
                statusDto.setStatus("ok");
                try {
                    ArrayList<Long> surveyIds = new ArrayList<Long>();
                    surveyIds.add(requestDto.getSurveyId());
                    SurveyUtils.notifyReportService(surveyIds, "invalidate");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        response.put("question_answer", responseDto);
        return response;
    }

    private boolean isValidCascadeResponse(Question question, JSONArray response) throws JSONException {
        boolean valid = false;
        ArrayList<String> responseNodeNames = new ArrayList<String>();
        for (int i = 0; i < response.length(); ++i) {
            responseNodeNames.add(response.getJSONObject(i).getString("name"));
        }
        List<CascadeNode> nodes = this.cascadeNodeDao.listByName(question.getCascadeResourceId(), responseNodeNames);
        List<List<CascadeNode>> cascadePathsList = this.createCascadeNodePaths(nodes);
        for (List<CascadeNode> path : cascadePathsList) {
            if (path.size() != response.length()) continue;
            ArrayList<String> pathNodeNames = new ArrayList<String>();
            for (int i = 0; i < path.size(); ++i) {
                pathNodeNames.add(path.get(i).getName());
            }
            if (!responseNodeNames.equals(pathNodeNames)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    private List<List<CascadeNode>> createCascadeNodePaths(List<CascadeNode> nodes) {
        ArrayList<List<CascadeNode>> pathsList = new ArrayList<List<CascadeNode>>();
        HashMap<Long, CascadeNode> nodesMap = new HashMap<Long, CascadeNode>();
        for (CascadeNode node : nodes) {
            nodesMap.put(node.getKey().getId(), node);
        }
        Iterator<CascadeNode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            CascadeNode node;
            CascadeNode currentNode = node = iterator.next();
            ArrayList<CascadeNode> path = new ArrayList<CascadeNode>();
            if (currentNode.getParentNodeId().equals(0L)) {
                path.add(currentNode);
            } else {
                while (currentNode != null && !currentNode.getParentNodeId().equals(0L)) {
                    path.add(currentNode);
                    currentNode = (CascadeNode)nodesMap.get(currentNode.getParentNodeId());
                }
                if (currentNode != null) {
                    path.add(currentNode);
                }
            }
            Collections.reverse(path);
            pathsList.add(path);
        }
        return pathsList;
    }

    private QuestionAnswerStore constructQAS(String id, String value) {
        QuestionAnswerStore qas = new QuestionAnswerStore();
        qas.setQuestionID(id);
        qas.setValue(value);
        return qas;
    }
}

