/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.survey.dao.CascadeResourceDao;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.waterforpeople.mapping.domain.CaddisflyResource;

public class CaddisflyResourceDao {
    private static ObjectMapper mapper = new ObjectMapper();
    public static String DEFAULT_CADDISFLY_TESTS_FILE_URL = "https://akvoflow-public.s3.amazonaws.com/caddisfly-tests.json";
    private static final Logger log = Logger.getLogger(CascadeResourceDao.class.getName());

    public List<CaddisflyResource> listResources(String caddisflyTestsUrl) {
        List result = null;
        try {
            URL caddisflyFileUrl = new URL(caddisflyTestsUrl);
            InputStream stream = caddisflyFileUrl.openStream();
            JsonNode rootNode = mapper.readTree(stream);
            result = (List)mapper.readValue(rootNode.get("tests"), (TypeReference)new TypeReference<List<CaddisflyResource>>(){});
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing Caddisfly resource: " + e.getMessage(), e);
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public List<CaddisflyResource> listResources() {
        return this.listResources(DEFAULT_CADDISFLY_TESTS_FILE_URL);
    }
}

