/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.waterforpeople.mapping.domain.SurveyAttributeMapping;

public class SurveyAttributeMappingDao
extends BaseDAO<SurveyAttributeMapping> {
    public SurveyAttributeMappingDao() {
        super(SurveyAttributeMapping.class);
    }

    public List<SurveyAttributeMapping> listMappingsBySurvey(Long surveyId) {
        return this.listByProperty("surveyId", surveyId, "Long");
    }

    public List<SurveyAttributeMapping> listMappingsByQuestionGroup(Long questionGroupId) {
        return this.listByProperty("questionGroupId", questionGroupId, "Long");
    }

    public void deleteMappingsForSurvey(Long surveyId) {
        List<SurveyAttributeMapping> mappings = this.listMappingsBySurvey(surveyId);
        if (mappings != null && mappings.size() > 0) {
            PersistenceManager pm = PersistenceFilter.getManager();
            pm.deletePersistentAll(mappings);
        }
    }

    public void deleteMappingsForQuestionGroup(Long questionGroupId) {
        List<SurveyAttributeMapping> mappings = this.listMappingsByQuestionGroup(questionGroupId);
        if (mappings != null && mappings.size() > 0) {
            PersistenceManager pm = PersistenceFilter.getManager();
            pm.deletePersistentAll(mappings);
        }
    }

    public SurveyAttributeMapping findMappingForAttribute(Long surveyId, String attributeName) {
        List<SurveyAttributeMapping> mappingList = this.findMappingsForAttribute(surveyId, attributeName);
        if (mappingList != null && mappingList.size() > 0) {
            return mappingList.get(0);
        }
        return null;
    }

    public List<SurveyAttributeMapping> findMappingsForAttribute(Long surveyId, String attributeName) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query q = pm.newQuery(SurveyAttributeMapping.class);
        q.setFilter("surveyId == surveyIdParam && attributeName == attrNameParam");
        q.declareParameters("Long surveyIdParam, String attrNameParam");
        return (List)q.execute((Object)surveyId, (Object)attributeName);
    }

    public SurveyAttributeMapping findMappingForQuestion(String questionId) {
        return (SurveyAttributeMapping)this.findByProperty("surveyQuestionId", questionId, "String");
    }
}

