/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.MailUtil;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.device.domain.DeviceFiles;
import com.gallatinsystems.framework.exceptions.SignedDataException;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.messaging.dao.MessageDao;
import com.gallatinsystems.messaging.domain.Message;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Survey;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.waterforpeople.mapping.app.web.dto.TaskRequest;
import org.waterforpeople.mapping.dao.DeviceFilesDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.Status;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.helper.SurveyEventHelper;
import org.waterforpeople.mapping.serialization.SurveyInstanceHandler;

public class TaskServlet
extends AbstractRestApiServlet {
    private static final String TSV_FILENAME = "data.txt";
    private static final String JSON_FILENAME = "data.json";
    private static String DEVICE_FILE_PATH;
    private static String FROM_ADDRESS;
    private static String BUCKET_NAME;
    private static final long serialVersionUID = -2607990749512391457L;
    private static final Logger log;
    private SurveyInstanceDAO siDao;
    private static final String EMAIL_FROM_ADDRESS_KEY = "emailFromAddress";
    private TreeMap<String, String> recepientList = null;
    private static final String OBJECTKEY_PREFIX = "devicezip/";
    private static final Object LOCK;

    public TaskServlet() {
        DEVICE_FILE_PATH = PropertyUtil.getProperty("deviceZipPath");
        FROM_ADDRESS = PropertyUtil.getProperty(EMAIL_FROM_ADDRESS_KEY);
        BUCKET_NAME = PropertyUtil.getProperty("s3bucket");
        this.siDao = new SurveyInstanceDAO();
        this.recepientList = MailUtil.loadRecipientList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SurveyInstance> processFile(TaskRequest fileProcessTaskRequest) {
        String fileName = fileProcessTaskRequest.getFileName();
        String androidId = fileProcessTaskRequest.getAndroidId();
        String phoneNumber = fileProcessTaskRequest.getPhoneNumber();
        String imei = fileProcessTaskRequest.getImei();
        String checksum = fileProcessTaskRequest.getChecksum();
        String url = DEVICE_FILE_PATH + fileName;
        try {
            S3Util.putObjectAcl(BUCKET_NAME, OBJECTKEY_PREFIX + fileName, S3Util.ACL.PRIVATE);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error trying to secure zip file: " + e.getMessage(), e);
        }
        URLConnection conn = null;
        BufferedInputStream deviceZipFileInputStream = null;
        ZipInputStream deviceFilesStream = null;
        Map<String, String> files = null;
        ArrayList<SurveyInstance> emptyList = new ArrayList<SurveyInstance>();
        try {
            conn = S3Util.getConnection(BUCKET_NAME, OBJECTKEY_PREFIX + fileName);
            deviceZipFileInputStream = new BufferedInputStream(conn.getInputStream());
            deviceFilesStream = new ZipInputStream(deviceZipFileInputStream);
            files = TaskServlet.extract(deviceFilesStream);
        }
        catch (Exception e) {
            int retry;
            block22: {
                ArrayList<SurveyInstance> arrayList;
                try {
                    retry = fileProcessTaskRequest.getRetry();
                    if (++retry <= 7) break block22;
                    String message = String.format("Failed to process file (%s) after (%s) retries.", url, 7);
                    this.sendMail(fileProcessTaskRequest, message);
                    log.severe(message + "\n\n" + e.getMessage());
                    arrayList = emptyList;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(deviceFilesStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)deviceFilesStream);
                return arrayList;
            }
            fileProcessTaskRequest.setRetry(retry);
            this.rescheduleTask(fileProcessTaskRequest);
            log.log(Level.WARNING, "Failed to process zip file: Rescheduling... " + url + " : " + e.getMessage());
            ArrayList<SurveyInstance> message = emptyList;
            IOUtils.closeQuietly((InputStream)deviceFilesStream);
            return message;
        }
        IOUtils.closeQuietly((InputStream)deviceFilesStream);
        DeviceFilesDao dfDao = new DeviceFilesDao();
        List<DeviceFiles> dfList = null;
        DeviceFiles deviceFile = null;
        dfList = dfDao.listByUri(url);
        if (dfList != null && dfList.size() > 0) {
            deviceFile = dfList.get(0);
        }
        if (deviceFile == null) {
            deviceFile = new DeviceFiles();
        }
        deviceFile.setProcessDate(this.getNowDateTimeFormatted());
        deviceFile.setProcessedStatus(Status.StatusCode.IN_PROGRESS);
        deviceFile.setURI(url);
        deviceFile.setAndroidId(androidId);
        deviceFile.setPhoneNumber(phoneNumber);
        deviceFile.setImei(imei);
        deviceFile.setChecksum(checksum);
        deviceFile.setUploadDateTime(new Date());
        ArrayList<SurveyInstance> surveyInstances = new ArrayList<SurveyInstance>();
        if (files.containsKey(JSON_FILENAME)) {
            SurveyInstance instance = SurveyInstanceHandler.fromJSON(files.get(JSON_FILENAME));
            if (instance != null) {
                surveyInstances.add(instance);
            }
        } else if (files.containsKey(TSV_FILENAME)) {
            Map<String, List<String>> data = this.splitSurveyInstances(files.get(TSV_FILENAME));
            for (String id : data.keySet()) {
                SurveyInstance instance = SurveyInstanceHandler.fromTSV(data.get(id));
                if (instance == null) continue;
                surveyInstances.add(instance);
            }
        }
        if (surveyInstances.isEmpty()) {
            String message = "Error empty file: " + deviceFile.getURI();
            log.log(Level.SEVERE, message);
            deviceFile.setProcessedStatus(Status.StatusCode.PROCESSED_WITH_ERRORS);
            deviceFile.addProcessingMessage(message);
            this.sendMail(fileProcessTaskRequest, message);
        } else {
            deviceFile.setProcessedStatus(Status.StatusCode.PROCESSED_NO_ERRORS);
            for (SurveyInstance si : surveyInstances) {
                Object object = LOCK;
                synchronized (object) {
                    si = this.siDao.save(si, deviceFile);
                }
                SurveyEventHelper.fireEvent("surveySubmission", si.getSurveyId(), si.getKey().getId());
            }
        }
        dfDao.save(deviceFile);
        if (dfList != null) {
            for (DeviceFiles dfitem : dfList) {
                dfitem.setProcessedStatus(deviceFile.getProcessedStatus());
            }
        }
        dfDao.save(dfList);
        return surveyInstances;
    }

    public static Map<String, String> extract(ZipInputStream deviceZipFileInputStream) throws ZipException, IOException, SignedDataException {
        ZipEntry entry;
        HashMap<String, String> files = new HashMap<String, String>();
        while ((entry = deviceZipFileInputStream.getNextEntry()) != null) {
            int size;
            String name = entry.getName();
            log.info("Unzipping: " + name);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((size = deviceZipFileInputStream.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, size);
            }
            if (out.size() <= 0) continue;
            files.put(name, out.toString("UTF-8"));
        }
        return files;
    }

    private Map<String, List<String>> splitSurveyInstances(String content) {
        HashMap<String, List<String>> instances = new HashMap<String, List<String>>();
        for (String line : content.split("\n")) {
            String id;
            String[] parts = (line = line.replaceAll("\u0000", "")).split("\t");
            if (parts.length < 5) {
                parts = line.split(",");
            }
            String string = id = parts.length >= 2 ? parts[1] : null;
            if (id == null) continue;
            ArrayList<String> lines = (ArrayList<String>)instances.get(id);
            if (lines == null) {
                lines = new ArrayList<String>();
            }
            lines.add(line);
            instances.put(id, lines);
        }
        return instances;
    }

    private void rescheduleTask(TaskRequest fileProcessingRequest) {
        Queue defaultQueue = QueueFactory.getDefaultQueue();
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/task").param("action", "processFile").param("retry", fileProcessingRequest.getRetry().toString()).param("fileName", fileProcessingRequest.getFileName()).countdownMillis(20000L);
        if (fileProcessingRequest.getAndroidId() != null) {
            options.param("androidId", fileProcessingRequest.getAndroidId());
        }
        if (fileProcessingRequest.getPhoneNumber() != null) {
            options.param("phoneNumber", fileProcessingRequest.getPhoneNumber());
        }
        if (fileProcessingRequest.getImei() != null) {
            options.param("imei", fileProcessingRequest.getImei());
        }
        if (fileProcessingRequest.getChecksum() != null) {
            options.param("checksum", fileProcessingRequest.getChecksum());
        }
        if (fileProcessingRequest.getOffset() != null) {
            options.param("offset", fileProcessingRequest.getOffset().toString());
        }
        defaultQueue.add(options);
    }

    private void sendMail(TaskRequest fileProcessingRequest, String body) {
        String fileName = fileProcessingRequest.getFileName();
        String subject = "Device File Processing Error: " + fileName;
        String messageBody = DEVICE_FILE_PATH + fileName + "\n" + body;
        MailUtil.sendMail(FROM_ADDRESS, "FLOW", this.recepientList, subject, messageBody);
    }

    private String getNowDateTimeFormatted() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH:mm:ss");
        Date date = new Date();
        String dateTime = dateFormat.format(date);
        return dateTime;
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        TaskRequest restRequest = new TaskRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest request) throws Exception {
        RestResponse response = new RestResponse();
        TaskRequest taskReq = (TaskRequest)request;
        if ("processFile".equalsIgnoreCase(taskReq.getAction())) {
            this.ingestFile(taskReq);
        }
        return response;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
    }

    private void ingestFile(TaskRequest req) {
        if (req.getFileName() != null) {
            Survey s;
            log.info("\tTask->processFile");
            List<SurveyInstance> surveyInstances = null;
            try {
                surveyInstances = this.processFile(req);
            }
            catch (Exception e) {
                String message = "Failed to process zip file:" + req.getFileName() + " : " + e.getMessage();
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                message = message + "\n" + sw.toString();
                log.severe(message);
                this.sendMail(req, message);
                surveyInstances = new ArrayList<SurveyInstance>();
            }
            HashMap<Long, Survey> surveyMap = new HashMap<Long, Survey>();
            SurveyDAO surveyDao = new SurveyDAO();
            Queue defaultQueue = QueueFactory.getDefaultQueue();
            for (SurveyInstance instance : surveyInstances) {
                s = (Survey)surveyMap.get(instance.getSurveyId());
                if (s == null) {
                    s = surveyDao.getById(instance.getSurveyId());
                    surveyMap.put(instance.getSurveyId(), s);
                }
                if (s != null && s.getRequireApproval() != null && s.getRequireApproval().booleanValue()) {
                    instance.setApprovedFlag("False");
                    continue;
                }
                defaultQueue.add(TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "ingestInstance").param("surveyInstanceId", instance.getKey().getId() + ""));
            }
            SurveyUtils.notifyReportService(surveyMap.keySet(), "invalidate");
            MessageDao msgDao = new MessageDao();
            Message message = new Message();
            message.setShortMessage(req.getFileName() + " processed - Surveys: " + surveyMap.keySet());
            if (req.getFileName().startsWith("wfpGenerated")) {
                message.setActionAbout("bulkProcessed");
            } else {
                message.setActionAbout("fileProcessed");
            }
            if (surveyMap.keySet().size() == 1 && (s = (Survey)surveyMap.values().iterator().next()) != null) {
                message.setObjectId(s.getKey().getId());
                message.setObjectTitle(s.getPath() + "/" + s.getName());
            }
            msgDao.save(message);
        }
    }

    static {
        log = Logger.getLogger(TaskServlet.class.getName());
        LOCK = new Object();
    }
}

