/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.analytics.summarization;

import com.gallatinsystems.framework.analytics.summarization.DataSummarizationRequest;
import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class DataSummarizationHandler
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 1689300636699166004L;
    protected Map<String, List<String>> summarizers;
    protected String queueName;
    protected String summarizerPath;

    public DataSummarizationHandler() {
        this.initializeSummarization();
    }

    protected abstract void initializeSummarization();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataSummarizationRequest restRequest = new DataSummarizationRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest request) throws Exception {
        RestResponse response = new RestResponse();
        DataSummarizationRequest summarizationRequest = (DataSummarizationRequest)request;
        List<String> applicableSummarizers = this.summarizers.get(summarizationRequest.getType());
        if (applicableSummarizers != null) {
            int idx;
            if (request.getAction() != null) {
                for (idx = 0; idx < applicableSummarizers.size() && !applicableSummarizers.get(idx).trim().equals(summarizationRequest.getAction()); ++idx) {
                }
            }
            if (idx < applicableSummarizers.size()) {
                boolean isCompleted = false;
                DataSummarizer summarizer = null;
                try {
                    Class<?> cls = Class.forName(applicableSummarizers.get(idx));
                    summarizer = (DataSummarizer)cls.newInstance();
                    isCompleted = summarizer.performSummarization(summarizationRequest.getObjectKey(), summarizationRequest.getType(), summarizationRequest.getValue(), summarizationRequest.getOffset(), summarizationRequest.getCursor());
                }
                catch (Exception e) {
                    this.log("Could not invoke summarizer. Setting complete to true to continue with processing", e);
                    isCompleted = true;
                }
                if (!isCompleted && summarizer != null) {
                    summarizationRequest.setAction(applicableSummarizers.get(idx));
                    summarizationRequest.setOffset(summarizationRequest.getOffset() + 10);
                    summarizationRequest.setCursor(summarizer.getCursor());
                    this.invokeSummarizer(summarizationRequest);
                } else if (idx < applicableSummarizers.size() - 1) {
                    summarizationRequest.setAction(applicableSummarizers.get(idx + 1));
                    this.invokeSummarizer(summarizationRequest);
                }
            }
        } else {
            this.log("No summarizers configured for type " + summarizationRequest.getType());
        }
        return response;
    }

    private void invokeSummarizer(DataSummarizationRequest request) {
        Queue queue = QueueFactory.getQueue((String)this.queueName);
        queue.add(TaskOptions.Builder.withUrl((String)this.summarizerPath).param("action", request.getAction()).param("objectKey", request.getObjectKey()).param("type", request.getType()).param("offset", request.getOffset().toString()).param("cursor", request.getCursor() != null ? request.getCursor() : ""));
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        resp.setCode("200");
    }
}

