/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.InstanceDataDto;

public class InstanceData {
    public final Map<Long, SortedMap<Long, String>> responseMap;
    public final SurveyInstanceDto surveyInstanceDto;
    public long maxIterationsCount;
    public String latestApprovalStatus;

    public InstanceData(InstanceDataDto instanceDataDto, Map<Long, Map<Long, String>> responseMap) {
        this(instanceDataDto.surveyInstanceData, responseMap);
        this.latestApprovalStatus = instanceDataDto.latestApprovalStatus;
    }

    public InstanceData(SurveyInstanceDto surveyInstanceDto, Map<Long, Map<Long, String>> responseMap) {
        HashMap<Long, SortedMap<Long, String>> sortedResponseMap = new HashMap<Long, SortedMap<Long, String>>();
        long maxIter = 0L;
        for (Map.Entry<Long, Map<Long, String>> entry : responseMap.entrySet()) {
            Map<Long, String> iterationsMap = entry.getValue();
            TreeMap<Long, String> sortedMap = new TreeMap<Long, String>();
            Long maxIteration = Collections.max(iterationsMap.keySet());
            maxIter = Math.max(maxIter, maxIteration);
            for (long i = 0L; i <= maxIteration; ++i) {
                String value = iterationsMap.get(i);
                sortedMap.put(i, value == null ? "" : value);
            }
            sortedResponseMap.put(entry.getKey(), sortedMap);
        }
        this.responseMap = sortedResponseMap;
        this.surveyInstanceDto = surveyInstanceDto;
        this.maxIterationsCount = maxIter;
    }

    public boolean addResponses(Map<Long, Map<Long, String>> additionalResponsesMap) {
        for (Map.Entry<Long, Map<Long, String>> entry : additionalResponsesMap.entrySet()) {
            Map<Long, String> iterationsMap = entry.getValue();
            TreeMap<Long, String> sortedMap = new TreeMap<Long, String>();
            Long maxIteration = Collections.max(iterationsMap.keySet());
            this.maxIterationsCount = Math.max(this.maxIterationsCount, maxIteration);
            for (long i = 0L; i <= maxIteration; ++i) {
                String value = iterationsMap.get(i);
                sortedMap.put(i, value == null ? "" : value);
            }
            if (this.responseMap.containsKey(entry.getKey())) {
                return false;
            }
            this.responseMap.put(entry.getKey(), sortedMap);
        }
        return true;
    }

    public String toString() {
        if (this.surveyInstanceDto != null) {
            return this.surveyInstanceDto.getKeyId() + " '" + this.surveyInstanceDto.getSurveyedLocaleIdentifier() + "'";
        }
        return "InstanceData with max iteration index " + Long.toString(this.maxIterationsCount);
    }
}

