/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/surveyed_locales"})
public class SurveyedLocaleRestService {
    private SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> listQuestions(@RequestParam(value="surveyGroupId", defaultValue="") Long surveyGroupId, @RequestParam(value="identifier", defaultValue="") String identifier, @RequestParam(value="displayName", defaultValue="") String displayName, @RequestParam(value="since", defaultValue="") String since) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        List<Object> sls = new ArrayList();
        ArrayList<SurveyedLocaleDto> locales = new ArrayList<SurveyedLocaleDto>();
        if (identifier != null && !"".equals(identifier)) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, null, identifier, null);
        } else if (displayName != null && !"".equals(displayName)) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, null, null, displayName);
        } else if (surveyGroupId != null) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, surveyGroupId, null, null);
        }
        for (SurveyedLocale sl : sls) {
            SurveyedLocaleDto dto = new SurveyedLocaleDto();
            DtoMarshaller.copyToDto(sl, dto);
            locales.add(dto);
        }
        Integer num = sls.size();
        String newSince = SurveyedLocaleDao.getCursor(sls);
        statusDto.setNum(num);
        statusDto.setSince(newSince);
        response.put("surveyed_locales", locales);
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{dataPointId}"})
    @ResponseBody
    public Map<String, Object> findDataPointById(@PathVariable(value="dataPointId") Long dataPointId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        SurveyedLocale dataPoint = (SurveyedLocale)this.surveyedLocaleDao.getByKey(dataPointId);
        SurveyedLocaleDto dto = null;
        if (dataPoint != null) {
            dto = new SurveyedLocaleDto();
            BeanUtils.copyProperties((Object)dataPoint, (Object)dto, (String[])Constants.EXCLUDED_PROPERTIES);
            dto.setKeyId(dataPoint.getKey().getId());
        }
        response.put("surveyed_locale", dto);
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteSurveyedLocaleById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        SurveyedLocale sl = (SurveyedLocale)this.surveyedLocaleDao.getByKey(id);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (sl != null) {
            this.surveyedLocaleDao.deleteSurveyedLocale(sl);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }
}

