/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.waterforpeople.mapping.dao.DeviceApplicationDao;
import org.waterforpeople.mapping.domain.DeviceApplication;

public class ApkRedirectServlet
extends HttpServlet {
    private static final long serialVersionUID = 8394168365501522124L;
    private static final String ANDROID = "androidPhone";
    private static final String FIELDSURVEY = "fieldSurvey";
    private static final String FLOWAPP = "flowapp";
    private static final String SATSTAT = "satStat";
    private static final String GPS_APP_PATH = "/gps";
    private static final String FLOW_APP_PATH = "/app";
    private static final String FLOW_APP2_PATH = "/app2";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DeviceApplicationDao dao = new DeviceApplicationDao();
        String servletPath = req.getServletPath();
        String appCode = "";
        if (FLOW_APP_PATH.equals(servletPath)) {
            appCode = FIELDSURVEY;
        } else if (FLOW_APP2_PATH.equals(servletPath)) {
            appCode = FLOWAPP;
        } else if (GPS_APP_PATH.equals(servletPath)) {
            appCode = SATSTAT;
        }
        List<DeviceApplication> apps = dao.listByDeviceTypeAndAppCode(ANDROID, appCode, 1);
        if (apps == null || apps.size() == 0 || StringUtils.isBlank((String)apps.get(0).getFileName())) {
            resp.setStatus(404);
            resp.getWriter().append("NOT FOUND");
            return;
        }
        resp.sendRedirect(apps.get(0).getFileName());
    }
}

