/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.user.app.gwt.client.UserConfigDto;
import com.gallatinsystems.user.dao.UserConfigDao;
import com.gallatinsystems.user.domain.UserConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.UserConfigPayload;

@Controller
@RequestMapping(value={"/user_configs"})
public class UserConfigRestService {
    private UserConfigDao userConfigDao = new UserConfigDao();

    @RequestMapping(method={RequestMethod.GET}, value={"/all"})
    @ResponseBody
    public Map<String, List<UserConfigDto>> listUserConfigs() {
        HashMap<String, List<UserConfigDto>> response = new HashMap<String, List<UserConfigDto>>();
        ArrayList<UserConfigDto> results = new ArrayList<UserConfigDto>();
        List userConfigs = this.userConfigDao.list("all");
        if (userConfigs != null) {
            for (UserConfig s : userConfigs) {
                UserConfigDto dto = new UserConfigDto();
                DtoMarshaller.copyToDto(s, dto);
                results.add(dto);
            }
        }
        response.put("user_configs", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<UserConfigDto>> listConfigsByUserId(@RequestParam(value="userId", defaultValue="") Long userId) {
        HashMap<String, List<UserConfigDto>> response = new HashMap<String, List<UserConfigDto>>();
        ArrayList<UserConfigDto> results = new ArrayList<UserConfigDto>();
        List<UserConfig> userConfigs = null;
        if (userId != null) {
            userConfigs = this.userConfigDao.listConfigsByUser(userId);
        }
        if (userConfigs != null) {
            for (UserConfig s : userConfigs) {
                UserConfigDto dto = new UserConfigDto();
                DtoMarshaller.copyToDto(s, dto);
                results.add(dto);
            }
        }
        response.put("user_configs", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, UserConfigDto> findUserConfig(@PathVariable(value="id") Long id) {
        HashMap<String, UserConfigDto> response = new HashMap<String, UserConfigDto>();
        UserConfig s = (UserConfig)this.userConfigDao.getByKey(id);
        UserConfigDto dto = null;
        if (s != null) {
            dto = new UserConfigDto();
            DtoMarshaller.copyToDto(s, dto);
        }
        response.put("user_config", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteUserConfigById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        UserConfig s = (UserConfig)this.userConfigDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (s != null) {
            this.userConfigDao.delete(s);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingUserConfig(@RequestBody UserConfigPayload payLoad) {
        UserConfig s;
        Long keyId;
        UserConfigDto userConfigDto = payLoad.getUser_config();
        HashMap<String, Object> response = new HashMap<String, Object>();
        UserConfigDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (userConfigDto != null && (keyId = userConfigDto.getKeyId()) != null && (s = (UserConfig)this.userConfigDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)userConfigDto, (Object)s, (String[])new String[]{"createdDateTime"});
            s = this.userConfigDao.save(s);
            dto = new UserConfigDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("user_config", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewUserConfig(@RequestBody UserConfigPayload payLoad) {
        UserConfigDto userConfigDto = payLoad.getUser_config();
        HashMap<String, Object> response = new HashMap<String, Object>();
        UserConfigDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (userConfigDto != null) {
            UserConfig s = new UserConfig();
            BeanUtils.copyProperties((Object)userConfigDto, (Object)s, (String[])new String[]{"createdDateTime"});
            s = this.userConfigDao.save(s);
            dto = new UserConfigDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("user_config", dto);
        return response;
    }
}

