/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.TranslationBulkDeletePayload;
import org.waterforpeople.mapping.app.web.rest.dto.TranslationBulkPayload;
import org.waterforpeople.mapping.app.web.rest.dto.TranslationPayload;

@Controller
@RequestMapping(value={"/translations"})
public class TranslationRestService {
    private TranslationDao tDao = new TranslationDao();
    private SurveyDAO sDao = new SurveyDAO();
    Map<String, Translation> translations = new HashMap<String, Translation>();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listTranslationsBySurveyId(@RequestParam(value="surveyId", defaultValue="") Long surveyId, @RequestParam(value="questionGroupId", defaultValue="") Long questionGroupId) {
        Survey survey;
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<TranslationDto> results = new ArrayList<TranslationDto>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        if (surveyId != null && (survey = this.sDao.getById(surveyId)) != null && questionGroupId != null) {
            this.addTranslations(Translation.ParentType.SURVEY_NAME, survey.getKey().getId(), surveyId, results);
            this.addTranslations(Translation.ParentType.SURVEY_DESC, survey.getKey().getId(), surveyId, results);
            List<Translation> translations = this.tDao.listTranslationsByQuestionGroup(questionGroupId);
            for (Translation t : translations) {
                TranslationDto tDto = new TranslationDto();
                DtoMarshaller.copyToDto(t, tDto);
                tDto.setLangCode(t.getLanguageCode());
                tDto.setSurveyId(surveyId);
                results.add(tDto);
            }
        }
        response.put("translations", results);
        return response;
    }

    private void addTranslations(Translation.ParentType parentType, long id, long surveyId, List<TranslationDto> results) {
        HashMap<String, Translation> translations = this.tDao.findTranslations(parentType, id);
        for (Translation t : translations.values()) {
            TranslationDto tDto = new TranslationDto();
            DtoMarshaller.copyToDto(t, tDto);
            tDto.setLangCode(t.getLanguageCode());
            tDto.setSurveyId(surveyId);
            results.add(tDto);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewTranslation(@RequestBody TranslationPayload payLoad) {
        TranslationDto translationDto = payLoad.getTranslation();
        HashMap<String, Object> response = new HashMap<String, Object>();
        TranslationDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("Cannot create translation");
        if (translationDto != null) {
            dto = this.createTranslation(translationDto);
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        response.put("translation", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/bulk"})
    @ResponseBody
    public Map<String, Object> bulkSaveNewTranslation(@RequestBody TranslationBulkPayload payLoad) {
        String status;
        List<TranslationDto> translationDtoList = payLoad.getTranslations();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<TranslationDto> results = new ArrayList<TranslationDto>();
        TranslationDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        Boolean stateSuccess = true;
        for (TranslationDto tDto : translationDtoList) {
            dto = this.createTranslation(tDto);
            if (dto != null) {
                results.add(dto);
                continue;
            }
            stateSuccess = false;
        }
        String string = status = stateSuccess != false ? "ok" : "failed";
        if (status.equals("failed")) {
            statusDto.setMessage("Cannot create translation");
        }
        statusDto.setStatus(status);
        response.put("meta", statusDto);
        response.put("translations", results);
        return response;
    }

    private TranslationDto createTranslation(TranslationDto translationDto) {
        Translation t = new Translation();
        BeanUtils.copyProperties((Object)translationDto, (Object)t, (String[])new String[]{"createdDateTime", "parentType", "langCode"});
        t.setLanguageCode(translationDto.getLangCode());
        if (translationDto.getParentType() != null) {
            t.setParentType(Translation.ParentType.valueOf(translationDto.getParentType().toString()));
        }
        t = this.tDao.save(t);
        TranslationDto tDto = new TranslationDto();
        DtoMarshaller.copyToDto(t, tDto);
        tDto.setLangCode(t.getLanguageCode());
        return tDto;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingTranslation(@RequestBody TranslationPayload payLoad) {
        TranslationDto tDto = payLoad.getTranslation();
        HashMap<String, Object> response = new HashMap<String, Object>();
        TranslationDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (tDto != null && (dto = this.updateTranslation(tDto)) != null) {
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("translation", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/bulk"})
    @ResponseBody
    public Map<String, Object> bulkSaveExistingTranslation(@RequestBody TranslationBulkPayload payLoad) {
        List<TranslationDto> translationDtoList = payLoad.getTranslations();
        HashMap<String, Object> response = new HashMap<String, Object>();
        TranslationDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        ArrayList<TranslationDto> results = new ArrayList<TranslationDto>();
        Boolean stateSuccess = true;
        for (TranslationDto tDto : translationDtoList) {
            dto = this.updateTranslation(tDto);
            if (dto != null) {
                results.add(dto);
                continue;
            }
            stateSuccess = false;
        }
        String status = stateSuccess != false ? "ok" : "failed";
        statusDto.setStatus(status);
        response.put("meta", statusDto);
        response.put("translations", results);
        return response;
    }

    private TranslationDto updateTranslation(TranslationDto tDto) {
        Translation t;
        Long keyId = tDto.getKeyId();
        if (keyId != null && (t = (Translation)this.tDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)tDto, (Object)t, (String[])new String[]{"createdDateTime", "parentType", "langCode", "surveyId"});
            t.setLanguageCode(tDto.getLangCode());
            if (tDto.getParentType() != null) {
                t.setParentType(Translation.ParentType.valueOf(tDto.getParentType().toString()));
            }
            t = this.tDao.save(t);
            TranslationDto dto = new TranslationDto();
            BeanUtils.copyProperties((Object)t, (Object)dto, (String[])new String[]{"parentType", "languageCode"});
            dto.setLangCode(t.getLanguageCode());
            if (t.getParentType() != null) {
                dto.setParentType(t.getParentType().toString());
            }
            if (t.getKey() != null) {
                dto.setKeyId(t.getKey().getId());
            }
            dto.setSurveyId(tDto.getSurveyId());
            return dto;
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteTranslationById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        Translation t = (Translation)this.tDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (t != null) {
            this.tDao.delete(t);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/bulk"})
    @ResponseBody
    public Map<String, RestStatusDto> bulkDeleteTranslationById(@RequestBody TranslationBulkDeletePayload payLoad) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        List<Number> tIds = payLoad.getTranslations();
        RestStatusDto statusDto = null;
        Translation t = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("ok");
        if (tIds != null && tIds.size() > 0) {
            for (int i = 0; i < tIds.size(); ++i) {
                Number temp = tIds.get(i);
                t = (Translation)this.tDao.getByKey(temp.longValue());
                if (t != null) {
                    this.tDao.delete(t);
                    continue;
                }
                statusDto.setStatus("failed");
            }
        }
        response.put("meta", statusDto);
        return response;
    }
}

