/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class SMSRestRequest
extends RestRequest {
    private static final long serialVersionUID = -4090095229806070007L;
    private static final String API_ID_PARAM = "Api_id";
    private static final String FROM_PARAM = "from";
    private static final String TO_PARAM = "to";
    private static final String TIME_PARAM = "timestamp";
    private static final String CHARSET_PARAM = "charset";
    private static final String TEXT_PARAM = "text";
    private static final ThreadLocal<DateFormat> DATE_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private String apiId;
    private String from;
    private String to;
    private Date timestamp;
    private String text;
    private String charset;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    protected void populateErrors() {
        if (this.text == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", TEXT_PARAM));
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.text = req.getParameter(TEXT_PARAM);
        if (this.text != null) {
            this.text = this.text.trim();
        }
        this.from = req.getParameter(FROM_PARAM);
        this.to = req.getParameter(TO_PARAM);
        String dateString = req.getParameter(TIME_PARAM);
        if (dateString != null) {
            try {
                this.timestamp = DATE_FMT.get().parse(dateString);
            }
            catch (Exception e) {
                this.addError(new RestError("5002", "Invalid data type", "Date format: yyyy-MM-dd HH:mm:ss"));
            }
        }
        this.charset = req.getParameter(CHARSET_PARAM);
        this.apiId = req.getParameter(API_ID_PARAM);
    }
}

