/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.events;

import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.common.util.PropertyUtil;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PostDelete;
import com.google.appengine.api.datastore.PostPut;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.utils.SystemProperty;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsr107cache.Cache;
import org.akvo.flow.events.EventUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class EventLogger {
    private static Logger logger = Logger.getLogger(EventLogger.class.getName());
    private static final long MIN_TIME_DIFF = 60000L;

    private void sendNotification() {
        try {
            String urlPath = PropertyUtil.getProperty("eventNotification");
            if (urlPath == null || urlPath.trim().length() == 0) {
                logger.log(Level.SEVERE, "Event notification URL not present in appengine-web.xml");
                return;
            }
            URL url = new URL(urlPath.trim());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            HashMap<String, String> messageMap = new HashMap<String, String>();
            String appId = SystemProperty.applicationId.get();
            messageMap.put("orgId", appId);
            messageMap.put("url", appId + ".appspot.com");
            ObjectMapper m = new ObjectMapper();
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            m.writeValue((Writer)writer, messageMap);
            writer.close();
            if (connection.getResponseCode() != 204) {
                logger.log(Level.SEVERE, "Unified log notification failed with status code: " + connection.getResponseCode());
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Unified log notification failed with malformed URL exception", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unified log notification failed with IO exception", e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unified log notification failed with error", e);
        }
    }

    private void notifyLog() {
        Cache cache = MemCacheUtils.initCache(3600);
        if (cache == null) {
            logger.log(Level.WARNING, "cache not accessible, but still sending notification to unified log");
            this.sendNotification();
            return;
        }
        if (cache.containsKey((Object)"unifiedLogNotified")) {
            Date cacheDate = (Date)cache.get((Object)"unifiedLogNotified");
            Date nowDate = new Date();
            Long deltaMils = nowDate.getTime() - cacheDate.getTime();
            if (deltaMils < 60000L) {
                return;
            }
        }
        this.sendNotification();
        cache.put((Object)"unifiedLogNotified", (Object)new Date());
    }

    private void storeEvent(Map<String, Object> event, Date timestamp) {
        try {
            DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
            ObjectMapper m = new ObjectMapper();
            StringWriter w = new StringWriter();
            m.writeValue((Writer)w, event);
            Entity entity = new Entity("EventQueue");
            entity.setProperty("createdDateTime", (Object)timestamp);
            entity.setProperty("lastUpdateDateTime", (Object)timestamp);
            String payload = w.toString();
            if (payload.length() > 500) {
                entity.setProperty("payloadText", (Object)new Text(payload));
            } else {
                entity.setProperty("payload", (Object)payload);
            }
            datastore.put(entity);
            this.notifyLog();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "could not store " + event.get("eventType") + " event. Error: " + e.toString(), e);
        }
    }

    @PostPut(kinds={"SurveyGroup", "Survey", "QuestionGroup", "Question", "SurveyInstance", "QuestionAnswerStore", "SurveyedLocale", "DeviceFiles"})
    void logPut(PutContext context) {
        try {
            if (!"true".equals(PropertyUtil.getProperty("enableChangeEvents"))) {
                return;
            }
            Entity current = (Entity)context.getCurrentElement();
            EventUtils.EventTypes types = EventUtils.getEventAndActionType(current.getKey().getKind());
            Date lastUpdateDatetime = (Date)current.getProperty("lastUpdateDateTime");
            Date createdDateTime = (Date)current.getProperty("createdDateTime");
            String actionType = createdDateTime.equals(lastUpdateDatetime) ? "Created" : "Updated";
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Map<String, Object> eventSource = EventUtils.newSource(authentication.getPrincipal());
            Date timestamp = (Date)((Entity)context.getCurrentElement()).getProperty("lastUpdateDateTime");
            Map<String, Object> eventContext = EventUtils.newContext(timestamp, eventSource);
            Map<String, Object> eventEntity = EventUtils.newEntity(types.type, ((Entity)context.getCurrentElement()).getKey().getId());
            EventUtils.populateEntityProperties(types.type, (Entity)context.getCurrentElement(), eventEntity);
            Map<String, Object> event = EventUtils.newEvent(SystemProperty.applicationId.get(), types.action + actionType, eventEntity, eventContext);
            this.storeEvent(event, timestamp);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not handle datastore put event: " + e.getMessage(), e);
        }
    }

    @PostDelete(kinds={"SurveyGroup", "Survey", "QuestionGroup", "Question", "SurveyInstance", "QuestionAnswerStore", "SurveyedLocale", "DeviceFiles"})
    void logDelete(DeleteContext context) {
        try {
            if (!"true".equals(PropertyUtil.getProperty("enableChangeEvents"))) {
                return;
            }
            EventUtils.EventTypes types = EventUtils.getEventAndActionType(((Key)context.getCurrentElement()).getKind());
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Object principal = authentication.getPrincipal();
            Map<String, Object> eventSource = EventUtils.newSource(principal);
            Date timestamp = new Date();
            Map<String, Object> eventContext = EventUtils.newContext(timestamp, eventSource);
            Map<String, Object> eventEntity = EventUtils.newEntity(types.type, ((Key)context.getCurrentElement()).getId());
            Map<String, Object> event = EventUtils.newEvent(SystemProperty.applicationId.get(), types.action + "Deleted", eventEntity, eventContext);
            this.storeEvent(event, timestamp);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not handle datastore delete event: " + e.getMessage(), e);
        }
    }
}

