/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class TranslationGenerator {
    private static final Map<String, String> PATTERNS = new HashMap<String, String>();
    private static final Pattern ANCHOR = Pattern.compile("<a.*?>.*?</a>");
    private static final Pattern T_HELPER = Pattern.compile("\\{\\{t\\s\\_\\w+\\}\\}");
    private static final Pattern BINDING = Pattern.compile(">\\{\\{.*?\\}\\}<");
    private static final Pattern AKVO_ORG = Pattern.compile(">akvo.org</a>");
    private static final String[] EXTS;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("<Dashboard> and <output> directories are required");
            return;
        }
        File sources = new File(args[0]);
        File output = new File(args[1]);
        Properties ui_strings = new Properties();
        ui_strings.load(new FileInputStream(new File(output, "/ui-strings.properties")));
        HashMap<String, String> trlKeys = new HashMap<String, String>();
        ArrayList<String> enValues = new ArrayList<String>();
        for (Object f : (List)FileUtils.listFiles((File)sources, (String[])EXTS, (boolean)true)) {
            if (((File)f).getAbsolutePath().contains("vendor") || ((File)f).getAbsolutePath().contains("plugins") || ((File)f).getAbsolutePath().contains("tests")) continue;
            List lines = FileUtils.readLines((File)f, (String)"UTF-8");
            int ln = 1;
            for (String line : lines) {
                List<String> keys;
                if (TranslationGenerator.containsTranslatableKeys(line) && !(keys = TranslationGenerator.getKeys(line)).isEmpty()) {
                    for (String k : keys) {
                        if (trlKeys.containsKey(k)) continue;
                        String en = ui_strings.getProperty(k);
                        if (en == null) {
                            System.err.println("Translation key `" + k + "` not found in ui-strings.properties");
                            ui_strings.put(k, "");
                        }
                        trlKeys.put(k, en == null ? "" : en);
                        if (en == null || "".equals(en) || enValues.contains(en)) continue;
                        enValues.add(en);
                    }
                }
                if (((File)f).getAbsolutePath().endsWith(".handlebars") && TranslationGenerator.containsMissingTranslation(line)) {
                    System.err.println("Check for missing translation in " + ((File)f).getName() + ":" + ln + " " + line);
                }
                ++ln;
            }
        }
        Collections.sort(enValues);
        StringBuffer sb = new StringBuffer();
        for (String val : enValues) {
            sb.append(val.replaceAll(" ", "\\\\ ")).append(" = ").append(val).append("\n");
        }
        FileUtils.writeStringToFile((File)new File(output, "/en.properties"), (String)sb.toString(), (String)"ISO-8859-1");
        ArrayList tmp = new ArrayList(trlKeys.keySet());
        Collections.sort(tmp);
        StringBuffer uisource = new StringBuffer();
        for (String ui : tmp) {
            uisource.append(ui).append(" = ").append((String)trlKeys.get(ui)).append("\n");
        }
        FileUtils.writeStringToFile((File)new File(output, "/ui-strings.properties"), (String)uisource.toString(), (String)"ISO-8859-1");
    }

    private static boolean containsMissingTranslation(String line) {
        Matcher m = ANCHOR.matcher(line);
        if (!m.find()) {
            return false;
        }
        Matcher m2 = T_HELPER.matcher(m.group());
        Matcher m3 = BINDING.matcher(m.group());
        Matcher m4 = AKVO_ORG.matcher(m.group());
        return !m2.find() && !m3.find() && !m4.find();
    }

    private static boolean containsTranslatableKeys(String line) {
        for (String pattern : PATTERNS.keySet()) {
            if (!line.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getKeys(String line) {
        if (!TranslationGenerator.containsTranslatableKeys(line)) {
            return Collections.emptyList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String pattern : PATTERNS.keySet()) {
            keys.addAll(TranslationGenerator.getKeysFromLine(line, pattern, PATTERNS.get(pattern)));
        }
        return keys;
    }

    private static List<String> getKeysFromLine(String line, String prefix, String suffix) {
        ArrayList<String> keys = new ArrayList<String>();
        int start = line.indexOf(prefix);
        int end = -1;
        if (start != -1) {
            end = line.indexOf(suffix, start += prefix.length());
        }
        while (start > 0 && end > 0) {
            keys.add(line.substring(start, end));
            start = line.indexOf(prefix, end + 1);
            if (start == -1) break;
            end = line.indexOf(suffix, start += prefix.length());
        }
        return keys;
    }

    static {
        PATTERNS.put("{{t ", "}}");
        PATTERNS.put("{{tooltip ", "}}");
        PATTERNS.put("promptBinding=\"Ember.STRINGS.", "\"");
        PATTERNS.put("placeholderBinding=\"Ember.STRINGS.", "\"");
        PATTERNS.put("String.loc('", "'");
        PATTERNS.put("(t> ", ")");
        EXTS = new String[]{"handlebars", "js", "cljs"};
    }
}

