/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.serialization;

import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.Question;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.domain.response.FormInstance;
import org.waterforpeople.mapping.domain.response.Response;

public class SurveyInstanceHandler {
    private static final Logger log = Logger.getLogger(SurveyInstanceHandler.class.getName());
    private static final int SURVEY_ID = 0;
    private static final int QUESTION_ID = 2;
    private static final int ANSWER_TYPE = 3;
    private static final int ANSWER_VALUE = 4;
    private static final int USERNAME = 5;
    private static final int COLLECTION_DATE = 7;
    private static final int DEVICE_ID = 8;
    private static final int UUID = 11;
    private static final int DURATION = 12;
    private static final int DATAPOINT_ID = 13;

    public static SurveyInstance fromJSON(String data) {
        FormInstance formInstance = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            formInstance = (FormInstance)mapper.readValue(data, FormInstance.class);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error mapping JSON data: " + e.getMessage(), e);
            return null;
        }
        SurveyInstance si = new SurveyInstance();
        si.setUserID(1L);
        si.setCollectionDate(new Date(formInstance.getSubmissionDate()));
        si.setSubmitterName(formInstance.getUsername());
        si.setDeviceIdentifier(formInstance.getDeviceId());
        si.setSurveyalTime(formInstance.getDuration());
        si.setSurveyId(SurveyInstanceHandler.retrieveFormId(formInstance));
        si.setSurveyedLocaleIdentifier(formInstance.getDataPointId());
        si.setUuid(formInstance.getUUID());
        si.setQuestionAnswersStore(new ArrayList<QuestionAnswerStore>());
        si.setFormVersion(formInstance.getFormVersion());
        for (Response response : formInstance.getResponses()) {
            QuestionAnswerStore qas = new QuestionAnswerStore();
            qas.setSurveyId(si.getSurveyId());
            qas.setQuestionID(response.getQuestionId());
            qas.setCollectionDate(si.getCollectionDate());
            qas.setType(response.getAnswerType());
            qas.setValue(response.getValue());
            qas.setIteration(response.getIteration());
            if ("META_NAME".equals(qas.getType())) {
                si.setSurveyedLocaleDisplayName(qas.getValue());
                continue;
            }
            if ("META_GEO".equals(qas.getType())) {
                si.setLocaleGeoLocation(qas.getValue());
                continue;
            }
            si.getQuestionAnswersStore().add(qas);
        }
        return si;
    }

    private static Long retrieveFormId(FormInstance formInstance) {
        if (StringUtils.isNotBlank((String)formInstance.getFormId()) && StringUtils.isNumeric((String)formInstance.getFormId())) {
            return Long.parseLong(formInstance.getFormId());
        }
        for (Response response : formInstance.getResponses()) {
            Long formId = SurveyInstanceHandler.retrieveFormIdByQuestionId(response.getQuestionId());
            if (formId == null) continue;
            return formId;
        }
        return null;
    }

    private static Long retrieveFormIdByQuestionId(String questionId) {
        if (questionId == null || questionId.trim().isEmpty()) {
            return null;
        }
        Question question = new QuestionDao().getByKey(Long.parseLong(questionId));
        if (question == null) {
            return null;
        }
        return question.getSurveyId();
    }

    public static SurveyInstance fromTSV(List<String> data) {
        SurveyInstance si = new SurveyInstance();
        si.setUserID(1L);
        si.setQuestionAnswersStore(new ArrayList<QuestionAnswerStore>());
        boolean first = true;
        for (String line : data) {
            String[] parts = line.split("\t");
            if (parts.length < 12) {
                return null;
            }
            if (first) {
                try {
                    si.setSurveyId(SurveyInstanceHandler.retrieveFormId(parts));
                    si.setCollectionDate(new Date(new Long(parts[7].trim())));
                }
                catch (NumberFormatException e) {
                    log.log(Level.SEVERE, "Could not parse line: " + line, e);
                    return null;
                }
                si.setSubmitterName(parts[5].trim());
                si.setDeviceIdentifier(parts[8].trim());
                si.setUuid(parts[11].trim());
                if (parts.length > 12) {
                    try {
                        si.setSurveyalTime(Long.valueOf(parts[12].trim()));
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.WARNING, "Surveyal time column is not a number", e);
                    }
                }
                if (parts.length > 13) {
                    si.setSurveyedLocaleIdentifier(parts[13].trim());
                }
                first = false;
            }
            QuestionAnswerStore qas = new QuestionAnswerStore();
            qas.setSurveyId(si.getSurveyId());
            qas.setQuestionID(parts[2].trim());
            qas.setType(parts[3].trim());
            qas.setCollectionDate(si.getCollectionDate());
            qas.setValue(parts[4].trim());
            if ("META_NAME".equals(qas.getType())) {
                si.setSurveyedLocaleDisplayName(qas.getValue());
                continue;
            }
            if ("META_GEO".equals(qas.getType())) {
                si.setLocaleGeoLocation(qas.getValue());
                continue;
            }
            si.getQuestionAnswersStore().add(qas);
        }
        return si;
    }

    private static Long retrieveFormId(String[] parts) {
        if (StringUtils.isNumeric((String)parts[0].trim())) {
            return Long.parseLong(parts[0].trim());
        }
        return SurveyInstanceHandler.retrieveFormIdByQuestionId(parts[2].trim());
    }
}

